/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online;

import java.util.Iterator;
import net.myrrix.common.LangUtils;
import net.myrrix.common.MutableRecommendedItem;
import net.myrrix.common.collection.FastByIDFloatMap;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;

final class MostPopularItemsIterator
implements Iterator<RecommendedItem> {
    private final MutableRecommendedItem delegate = new MutableRecommendedItem();
    private final Iterator<FastByIDFloatMap.MapEntry> countsIterator;
    private final IDRescorer rescorer;

    MostPopularItemsIterator(Iterator<FastByIDFloatMap.MapEntry> countsIterator, IDRescorer rescorer) {
        this.countsIterator = countsIterator;
        this.rescorer = rescorer;
    }

    @Override
    public boolean hasNext() {
        return this.countsIterator.hasNext();
    }

    @Override
    public RecommendedItem next() {
        FastByIDFloatMap.MapEntry entry = this.countsIterator.next();
        long id = entry.getKey();
        float value = entry.getValue();
        IDRescorer theRescorer = this.rescorer;
        if (theRescorer != null) {
            if (theRescorer.isFiltered(id)) {
                return null;
            }
            if (!LangUtils.isFinite(value = (float)theRescorer.rescore(id, value))) {
                return null;
            }
        }
        this.delegate.set(id, value);
        return this.delegate;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

