/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online.generation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.myrrix.common.collection.FastByIDMap;
import net.myrrix.common.collection.FastIDSet;
import net.myrrix.common.math.IllConditionedSolverException;
import net.myrrix.common.math.MatrixUtils;
import net.myrrix.common.math.Solver;
import net.myrrix.online.candidate.CandidateFilter;
import net.myrrix.online.candidate.CandidateFilterFactory;
import net.myrrix.online.generation.IDCluster;
import org.apache.commons.math3.linear.RealMatrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Generation {
    private static final Logger log = LoggerFactory.getLogger(Generation.class);
    public static final String NO_KNOWN_ITEMS_KEY = "model.noKnownItems";
    private final FastByIDMap<FastIDSet> knownItemIDs;
    private final FastByIDMap<FastIDSet> knownUserIDs;
    private final FastByIDMap<float[]> X;
    private Solver XTXsolver;
    private final FastByIDMap<float[]> Y;
    private Solver YTYsolver;
    private final FastIDSet itemTagIDs;
    private final FastIDSet userTagIDs;
    private final List<IDCluster> userClusters;
    private final List<IDCluster> itemClusters;
    private CandidateFilter candidateFilter;
    private final ReadWriteLock xLock;
    private final ReadWriteLock yLock;
    private final ReadWriteLock knownItemLock;
    private final ReadWriteLock knownUserLock;
    private final ReadWriteLock userClustersLock;
    private final ReadWriteLock itemClustersLock;

    public Generation(FastByIDMap<FastIDSet> knownItemIDs, FastByIDMap<float[]> X, FastByIDMap<float[]> Y) {
        this(knownItemIDs, X, Y, new FastIDSet(1000, 1.25f), new FastIDSet(1000, 1.25f));
    }

    public Generation(FastByIDMap<FastIDSet> knownItemIDs, FastByIDMap<float[]> X, FastByIDMap<float[]> Y, FastIDSet itemTagIDs, FastIDSet userTagIDs) {
        this(knownItemIDs, X, Y, itemTagIDs, userTagIDs, Lists.newArrayList(), Lists.newArrayList());
    }

    public Generation(FastByIDMap<FastIDSet> knownItemIDs, FastByIDMap<float[]> X, FastByIDMap<float[]> Y, FastIDSet itemTagIDs, FastIDSet userTagIDs, List<IDCluster> userClusters, List<IDCluster> itemClusters) {
        Preconditions.checkNotNull(X);
        Preconditions.checkNotNull(Y);
        Preconditions.checkNotNull(itemTagIDs);
        Preconditions.checkNotNull(userTagIDs);
        Preconditions.checkNotNull(userClusters);
        Preconditions.checkNotNull(itemClusters);
        this.knownItemIDs = knownItemIDs;
        this.knownUserIDs = null;
        this.X = X;
        this.XTXsolver = null;
        this.Y = Y;
        this.YTYsolver = null;
        this.itemTagIDs = itemTagIDs;
        this.userTagIDs = userTagIDs;
        this.userClusters = userClusters;
        this.itemClusters = itemClusters;
        this.candidateFilter = null;
        this.xLock = new ReentrantReadWriteLock();
        this.yLock = new ReentrantReadWriteLock();
        this.knownItemLock = new ReentrantReadWriteLock();
        this.knownUserLock = null;
        this.userClustersLock = new ReentrantReadWriteLock();
        this.itemClustersLock = new ReentrantReadWriteLock();
        this.recomputeState();
    }

    void recomputeState() {
        if (Boolean.parseBoolean(System.getProperty("model.solver.xtx.compute", "true"))) {
            this.XTXsolver = Generation.recomputeSolver(this.X, this.xLock.readLock());
        }
        if (Boolean.parseBoolean(System.getProperty("model.solver.yty.compute", "true"))) {
            this.YTYsolver = Generation.recomputeSolver(this.Y, this.yLock.readLock());
        }
        this.candidateFilter = CandidateFilterFactory.buildCandidateFilter(this.Y, this.yLock.readLock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Solver recomputeSolver(FastByIDMap<float[]> M, Lock readLock) {
        readLock.lock();
        try {
            if (M == null || M.isEmpty()) {
                Solver solver = null;
                return solver;
            }
            RealMatrix MTM = MatrixUtils.transposeTimesSelf(M);
            double infNorm = MTM.getNorm();
            if (infNorm < 1.0) {
                log.warn("X'*X or Y'*Y has small inf norm ({}); try decreasing model.als.lambda", (Object)infNorm);
                throw new IllConditionedSolverException("infNorm: " + infNorm);
            }
            Solver solver = MatrixUtils.getSolver(MTM);
            return solver;
        }
        finally {
            readLock.unlock();
        }
    }

    public int getNumUsers() {
        return this.X.size();
    }

    public int getNumItems() {
        return this.Y.size();
    }

    public FastByIDMap<float[]> getX() {
        return this.X;
    }

    public Solver getXTXSolver() {
        return this.XTXsolver;
    }

    public FastByIDMap<float[]> getY() {
        return this.Y;
    }

    public Solver getYTYSolver() {
        return this.YTYsolver;
    }

    public FastByIDMap<FastIDSet> getKnownItemIDs() {
        return this.knownItemIDs;
    }

    public FastByIDMap<FastIDSet> getKnownUserIDs() {
        return this.knownUserIDs;
    }

    public FastIDSet getItemTagIDs() {
        return this.itemTagIDs;
    }

    public FastIDSet getUserTagIDs() {
        return this.userTagIDs;
    }

    public List<IDCluster> getUserClusters() {
        return this.userClusters;
    }

    public List<IDCluster> getItemClusters() {
        return this.itemClusters;
    }

    public CandidateFilter getCandidateFilter() {
        return this.candidateFilter;
    }

    public ReadWriteLock getXLock() {
        return this.xLock;
    }

    public ReadWriteLock getYLock() {
        return this.yLock;
    }

    public ReadWriteLock getKnownItemLock() {
        return this.knownItemLock;
    }

    public ReadWriteLock getKnownUserLock() {
        return this.knownUserLock;
    }

    public ReadWriteLock getUserClustersLock() {
        return this.userClustersLock;
    }

    public ReadWriteLock getItemClustersLock() {
        return this.itemClustersLock;
    }
}

