% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cenCompareCdfs.R
\name{cenCompareCdfs}
\alias{cenCompareCdfs}
\title{Comparison of empirical cdf of censored data}
\usage{
cenCompareCdfs(x.var, cens.var, dist3 = "norm", Yname = yname)
}
\arguments{
\item{x.var}{The column of y (response variable) values plus detection limits}

\item{cens.var}{The column of indicators, where 1 (or \code{TRUE}) indicates a detection limit in the \code{y.var} column, and 0 (or \code{FALSE}) indicates a detected value in \code{y.var}.}

\item{dist3}{Name of the third distribution to be plotted, default is \code{norm} (normal distribution). Alternate third distribution is \code{weibull}(for Weibull distribution).  Log-normal and gamma distributions are always used.}

\item{Yname}{Optional – input text in quotes to be used as the variable name.  The default is the name of the \code{y.var} input variable.}
}
\value{
prints a plot of the empirical CDFs with BIC value for each distribution.
}
\description{
Plots the empirical cdf and cdfs of three theoretical distributions, fit by maximum likelihood estimation (MLE).
}
\examples{

data(Brumbaugh)
cenCompareCdfs(Brumbaugh$Hg,Brumbaugh$HgCen)

# With Weibull distribution
cenCompareCdfs(Brumbaugh$Hg,Brumbaugh$HgCen,dist3="weibull")

# Using an distribution not supported by this function (yet)
# you will get an error message
\dontrun{cenCompareCdfs(Brumbaugh$Hg,Brumbaugh$HgCen,dist3="beta")}

# With Yname specified
cenCompareCdfs(Brumbaugh$Hg,Brumbaugh$HgCen,Yname="TCE Conc (ug/L)\nLong Island, NY USA")
}
\references{
Helsel, D.R., 2011. Statistics for Censored Environmental Data using Minitab and R, 2nd ed. John Wiley & Sons, USA, N.J.

Delignette-Muller, M., Dutang, C., 2015. fitdistrplus : An R Package for Fitting Distributions. Journal of Statistical Software, 64, 1-34. http://www.jstatsoft.org/v64/i04/.
}
