% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NBBDesigns.R
\name{pnbbd1}
\alias{pnbbd1}
\title{PNBB Design of Type 1 (PNBBD 1)}
\usage{
pnbbd1(v)
}
\arguments{
\item{v}{Number of treatments (v), v>4 should be of the form v=s^2. For example v= 8, 9…..}
}
\description{
A block design with neighbour effects is said to be partially neighbour balanced based on m-class association scheme if two treatments 'Theta' and 'Phi' that are mutually u-th associates (u = 1, 2,…, m) appear as neighbours (left and right) 'Mu'_1u times. For this class of design 'Mu'_11=1 and 'Mu'_12=0. The number of first associates is (v/2) and number of second associates is (v/2 -1).
When v is a power of 2, the function will generate a class of partially neighbour balanced block designs. It also gives the parameters of the design, information matrix for estimating the contrast pertaining to direct and neighbour effects (both left and right) of the treatments.
}
\note{
Here v should be greater than 4 i.e v>4.
}
\examples{
library(NBBDesigns)
pnbbd1(8)
}
\references{
Azais, J.M., Bailey, R.A. and Monod, H. (1993)<DOI: 10.2307/2532269>."A catalogue of efficient neighbour designs with border plots".
}
