% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{get_id_cols}
\alias{get_id_cols}
\alias{get_id_cols_abcd}
\alias{get_id_cols_hbcd}
\title{Get identifier columns}
\usage{
get_id_cols(study, release = "latest")

get_id_cols_abcd(...)

get_id_cols_hbcd(...)
}
\arguments{
\item{study}{character. The study name. One of "abcd" or "hbcd".}

\item{release}{character. Release version (Default: \code{"latest"}).}

\item{...}{Additional arguments passed to the underlying
\code{\link[=get_id_cols]{get_id_cols()}} function.}
}
\value{
character vector with the identifier columns.
}
\description{
Retrieves the identifier columns for a given study and release version.

In addition to the main \code{get_id_cols()} function, there are two
study-specific variations:
\itemize{
\item \code{get_id_cols_abcd()}: for the ABCD study.
\item \code{get_id_cols_hbcd()}: for the HBCD study.
}

They have the same arguments as the \code{get_id_cols()} function, except
that the \code{study} argument is set to the respective study by default, and
should not be set by the user.
}
\examples{
get_id_cols("abcd")

get_id_cols("hbcd")

get_id_cols_abcd(release = "6.0")

get_id_cols_hbcd(release = "1.0")
}
