% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{TSfit_volatility}
\alias{TSfit_volatility}
\title{Calculate the volatility term structure of futures returns}
\usage{
TSfit_volatility(parameters, futures, futures_TTM, dt)
}
\arguments{
\item{parameters}{\code{vector}. A named vector of parameters of an N-factor model. Function \code{NFCP_parameters} is recommended.}

\item{futures}{\code{matrix}. Historical observes futures price data. Each column must correspond to a listed futures contract and each row must correspond to a discrete observation of futures contracts. NA's are permitted.}

\item{futures_TTM}{\code{vector}. Each element of 'futures_TTM' must correspond to the time-to-maturity from the current observation point of futures contracts listed in object 'futures'.}

\item{dt}{\code{numeric}. Constant, discrete time step of observations, in years.}
}
\value{
\code{TSfit_volatility} returns a matrix with the theoretical and empirical volatility term structure of futures returns, with the number of columns of this matrix coinciding with the number of input futures contracts.
}
\description{
Estimate the theoretical and empirical volatility term structure of futures returns
}
\details{
\loadmathjax

The fit of an N-factor models theoretical volatility term structure of futures returns to those obtained directly from observed futures prices can be used as a measure of robustness for
the models ability to explain the behaviour of a commodities term structure.

The theoretical model volatility term structure of futures returns is given by the following equation:

\mjdeqn{\sigma_F(\tau) = \sum_{i=1}^N \sum_{j=1}^N \sigma_i \sigma_j \rho_{i,j} e^{-(\kappa_i + \kappa_j)\tau}}{sigma_F(tau) = sum_{i = 1, j = 1}^N sigma[i] sigma[j] rho[i,j] e^(-(kappa[i] + kappa[j]) tau)}

Under the case that \mjeqn{\kappa_1 = 0}{kappa[1] = 0}, the model volatility term structure converges to \mjeqn{\sigma_1^2}{sigma[1]^2} as \mjeqn{\tau}{tau} grows large.

The empirical volatility term structure of futures returns is given by:

\mjdeqn{\hat\sigma_F^2(\tau) = \frac{1}{\Delta t}\sum_{i=1}^N(log(F(t_i,\tau)/F(t_i-\Delta t,\tau)) - \bar\mu)^2}{hat(sigma)[F^2](tau) = 1/(Delta * t) sum_{i=1}^N (log(F(t[i],tau) / F(t[i] - Delta t, tau)) - bar(mu))^2}

According to Cortazar and Naranjo (2006): "A larger number of factors gives more flexibility to adjust first and second moments simultaneously, hence explaining why (a) four-factor (may) outperform (a) three-factor one in fitting the volatility term structure."
}
\examples{
# Test the volatility term structure fit of the Schwartz-Smith two-factor model on crude oil:
V_TSFit <- TSfit_volatility(
parameters = SS_oil$two_factor,
futures = SS_oil$stitched_futures,
futures_TTM = SS_oil$stitched_TTM,
dt = SS_oil$dt)

}
\references{
Schwartz, E. S., and J. E. Smith, (2000). Short-Term Variations and Long-Term Dynamics in Commodity Prices. \emph{Manage. Sci.}, 46, 893-911.

Cortazar, G., and L. Naranjo, (2006). An N-factor Gaussian model of oil futures prices. \emph{Journal of Futures Markets: Futures, Options, and Other Derivative Products}, 26(3), 243-268.
}
