% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract-nonmissing-submatrix.R
\name{extractSubMatrix}
\alias{extractSubMatrix}
\title{Extract the percentage-cut-off non-missing sub-matrices in a given matrix.}
\usage{
extractSubMatrix(
  x,
  shape = "All",
  verbose = FALSE,
  palette = "Greys",
  row.vars = NULL,
  col.vars = NULL,
  bar = 1,
  plot_weight = FALSE,
  print_skim = TRUE
)
}
\arguments{
\item{x}{A matrix including valid values and NAs.}

\item{shape}{A string array indicating the shape of the output, by defalut is
"All", other options are "Square", "Rectangular_row", "Rectangular_col",
"Rectangular_element_max".}

\item{verbose}{A Boolean value, If \code{TRUE}, the plot will be saved as the
.png file in the working directory. By default is \code{FALSE}.}

\item{palette}{A string or number. Color palette used for the heatmap. By
default is 'Blues'. (Find the option in the ggplot2 manual 'Sequential,
diverging and qualitative colour scales from ColorBrewer')}

\item{row.vars}{A string, the name for the row variable.}

\item{col.vars}{A string, the name for the column variable.}

\item{bar}{A numeric value bigger than0 and less or equal to 0. The cut-off
percentage, i.e., the proportion of non missing values. By default is 1,
which means there is no missing value in sub-matrices. This argument is not
applicable for elements-max sub-matrix.}

\item{plot_weight}{A A Boolean value, If \code{TRUE}, then the funtion will
print matrices with weights, otherwise it will print the matrices with all
weights as 1.}

\item{print_skim}{A Boolean value, If \code{TRUE}, then the funtion will
print \code{\link[skimr]{skim}} information in console.}
}
\value{
A matrix or a list of matrices, with non(bar = 1) or few missing
value inside.
}
\description{
This function arrange the input matrix, extract the sub-matrices
without any missing value or with specific proportion of missing values
(not for elements-max matrix). The result will also be showed as plotly
figure.
}
\details{
The extraction process has two types of data preprocessing, the
difference is that the first one directly uses the original input matrix
(row-wise), while the second one uses the transposed matrix (column-wise).
After preprocessing, the matrix will be "three-step arrangement", the first
step is row arranging, the second step is col arranging, and the third step
is total rearranging. Then look for the largest possible matrix (with no
missing values) in the four dimensions, output the result and print the
visualization.
}
\examples{
# load some data from beatAML dataset
data <- NIMAA::beatAML[1:10000,]

# convert to incidence matrix
inc_mat <- NIMAA::el2IncMatrix(data, print_skim = FALSE)

# extract sub-matricess without missing value
sub_matrices <- extractSubMatrix(
inc_mat,
print_skim = FALSE,
col.vars = "patient_id",
row.vars = "inhibitor",
verbose = FALSE
)
}
\seealso{
\code{\link[dplyr]{arrange}}, \code{\link[dplyr]{arrange_if}}
}
