% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlm_planargradient.R
\name{nlm_planargradient}
\alias{nlm_planargradient}
\title{nlm_planargradient}
\usage{
nlm_planargradient(ncol, nrow, resolution = 1, direction = NA,
  rescale = TRUE)
}
\arguments{
\item{ncol}{[\code{numerical(1)}]\cr
Number of columns for the raster.}

\item{nrow}{[\code{numerical(1)}]\cr
Number of rows for the raster.}

\item{resolution}{[\code{numerical(1)}]\cr
Resolution of the raster.}

\item{direction}{[\code{numerical(1)}]\cr
Direction of the gradient in degrees, if unspecified the direction is randomly
determined.}

\item{rescale}{[\code{logical(1)}]\cr
If \code{TRUE} (default), the values are rescaled between 0-1.}
}
\value{
RasterLayer
}
\description{
Create a planar gradient neutral landscape model.
}
\details{
Simulates a linear gradient sloping in a specified or random direction.
}
\examples{
# simulate planar gradient
planar_gradient <- nlm_planargradient(ncol = 200, nrow = 200)

\dontrun{
# visualize the NLM
util_plot(planar_gradient)
}

}
\references{
Palmer, M.W. (1992) The coexistence of species in fractal landscapes.
\emph{The American Naturalist}, 139, 375 - 397.
}
\seealso{
\code{\link{nlm_distancegradient}},
\code{\link{nlm_edgegradient}}
}
