% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_nlm.R
\name{theme_nlm}
\alias{theme_nlm}
\alias{theme_nlm}
\alias{theme_nlm_discrete}
\alias{theme_nlm_grey}
\alias{theme_nlm_grey_discrete}
\title{theme_nlm}
\usage{
theme_nlm(base_family = "serif", base_size = 11.5,
  plot_title_family = "serif", plot_title_size = 18,
  plot_title_face = "bold", plot_title_margin = 10,
  subtitle_family = "serif", subtitle_size = 13, subtitle_face = "plain",
  subtitle_margin = 15, strip_text_family = base_family,
  strip_text_size = 12, strip_text_face = "plain",
  caption_family = "serif", caption_size = 9, caption_face = "plain",
  caption_margin = 10, legend_title = "Z",
  plot_margin = ggplot2::margin(30, 30, 30, 30), ratio = 1,
  viridis_scale = "D")

theme_nlm_discrete(base_family = "serif", base_size = 11.5,
  plot_title_family = base_family, plot_title_size = 18,
  plot_title_face = "bold", plot_title_margin = 10,
  subtitle_family = "serif", subtitle_size = 13, subtitle_face = "plain",
  subtitle_margin = 15, strip_text_family = base_family,
  strip_text_size = 12, strip_text_face = "plain",
  caption_family = "serif", caption_size = 9, caption_face = "plain",
  caption_margin = 10, legend_title = "Z", legend_labels = NULL,
  plot_margin = ggplot2::margin(30, 30, 30, 30), ratio = 1,
  viridis_scale = "D")

theme_nlm_grey(base_family = "serif", base_size = 11.5,
  plot_title_family = base_family, plot_title_size = 18,
  plot_title_face = "bold", plot_title_margin = 10,
  subtitle_family = "serif", subtitle_size = 13, subtitle_face = "plain",
  subtitle_margin = 15, strip_text_family = base_family,
  strip_text_size = 12, strip_text_face = "plain",
  caption_family = "serif", caption_size = 9, caption_face = "plain",
  caption_margin = 10, legend_title = "Z",
  plot_margin = ggplot2::margin(30, 30, 30, 30), ratio = 1,
  viridis_scale = "D")

theme_nlm_grey_discrete(base_family = "serif", base_size = 11.5,
  plot_title_family = base_family, plot_title_size = 18,
  plot_title_face = "bold", plot_title_margin = 10,
  subtitle_family = "serif", subtitle_size = 13, subtitle_face = "plain",
  subtitle_margin = 15, strip_text_family = base_family,
  strip_text_size = 12, strip_text_face = "plain",
  caption_family = "serif", caption_size = 9, caption_face = "plain",
  caption_margin = 10, legend_title = "Z", legend_labels = NULL,
  plot_margin = ggplot2::margin(30, 30, 30, 30), ratio = 1,
  viridis_scale = "D")
}
\arguments{
\item{base_family}{[\code{character}()]  base font family size}

\item{base_size}{[\code{numeric}(1)] base font size}

\item{plot_title_family}{[\code{character}()] plot title family}

\item{plot_title_size}{[\code{character}()] plot title size}

\item{plot_title_face}{[\code{character}()] plot title face}

\item{plot_title_margin}{[\code{numeric}(1)] plot title margin}

\item{subtitle_family}{[\code{character}()] plot subtitle family}

\item{subtitle_size}{[\code{numeric}(1)] plot subtitle size}

\item{subtitle_face}{[\code{character}()]` plot subtitle face}

\item{subtitle_margin}{[\code{numeric}(1)]
plot subtitle margin bottom (single numeric value)}

\item{strip_text_family}{[\code{character}()] facet facet label font family}

\item{strip_text_size}{[\code{numeric}(1)]
facet label font family, face and size}

\item{strip_text_face}{[\code{character}()] facet facet label font face}

\item{caption_family}{[\code{character}()] plot caption family}

\item{caption_size}{[\code{numeric}(1)] plot caption size}

\item{caption_face}{[\code{character}()] plot caption face}

\item{caption_margin}{[\code{numeric}(1)] plot caption margin}

\item{legend_title}{[\code{character}()] Title of the legend (default "Z")}

\item{plot_margin}{[\code{character}()]
plot margin (specify with \code{ggplot2::margin})}

\item{ratio}{[\code{character}()]
ratio for tiles (default 1, if your raster is not a square the ratio should
be \code{raster::nrow(x) / raster::ncol(x)})}

\item{viridis_scale}{[\code{character}(1)]
Five options are available: "viridis - magma" (= "A"),
                            "viridis - inferno" (= "B"),
                            "viridis - plasma" (= "C"),
                            "viridis - viridis" (= "D",  the default option)}

\item{legend_labels}{[\code{character}()] Labels for the legend ticks, if
used with \code{\link{util_plot}} they are automatically derived.}
}
\description{
Opinionated ggplot2 theme to visualize NLM raster.
}
\details{
A focused theme to visualize raster data that sets a lot of defaults for the
\code{ggplot2::theme}.

The theme can make use of the Roboto Condensed font (Open Source font from
Google).
If your local font library does not contain Roboto as a font, you can
import it via \code{\link{util_import_roboto_condensed}} (highly recommended).

The functions are setup in such a way that you can customize your own one by
just wrapping the call and changing the parameters.
The theme itself is heavily influenced by hrbrmstr and his package
hrbrthemes (\url{https://github.com/hrbrmstr/hrbrthemes/}).
}
\examples{
# nolint start
\dontrun{
# simulate NLM
x <- nlm_random(ncol = 75,
                nrow = 75)
# classify
y <- c(0.5, 0.15, 0.25)
y <- util_classify(x, y, c("1", "2", "3"))

# color + continuous
rasterVis::gplot(x) +
  ggplot2::geom_tile(ggplot2::aes(fill = value)) +
  ggplot2::labs(x = "Easting",
                y = "Northing") +
  theme_nlm() +
  ggplot2::ggtitle("Random NLM with continuous viridis color scale",
                   subtitle = "75x75 cells") +
  ggplot2::labs(caption = "Random map simulated with the R package NLMR.")

# grey + continuous
rasterVis::gplot(x) +
  ggplot2::geom_tile(ggplot2::aes(fill = value)) +
  ggplot2::labs(x = "Easting",
                y = "Northing") +
  theme_nlm_grey() +
  ggplot2::ggtitle("Random NLM with continuous grey color scale",
                   subtitle = "75x75 cells") +
  ggplot2::labs(caption = "Random map simulated with the R package NLMR.")

# color + discrete
rasterVis::gplot(y) +
  ggplot2::geom_tile(ggplot2::aes(fill = factor(value))) +
  ggplot2::labs(x = "Easting",
                y = "Northing") +
  theme_nlm_discrete() +
  ggplot2::ggtitle("Random NLM with discrete viridis color scale",
                   subtitle = "75x75 cells") +
  ggplot2::labs(caption = "Random map simulated with the R package NLMR.")

# grey + discrete
rasterVis::gplot(y) +
  ggplot2::geom_tile(ggplot2::aes(fill = factor(value))) +
  ggplot2::labs(x = "Easting",
                y = "Northing") +
  theme_nlm_grey_discrete() +
  ggplot2::ggtitle("Random NLM with discrete grey color scale",
                   subtitle = "75x75 cells") +
  ggplot2::labs(caption = "Random map simulated with the R package NLMR.")
# nolint end
}

}
\seealso{
\code{\link{util_import_roboto_condensed}}
}
