% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.R
\name{make_boot_datasets}
\alias{make_boot_datasets}
\title{Prepare a bootstrap tibble}
\usage{
make_boot_datasets(
  m,
  samples = 10,
  data_folder = "DerivedData/bootstrap_datasets",
  overwrite = FALSE,
  id_var = "ID",
  ...
)
}
\arguments{
\item{m}{An nm object.}

\item{samples}{Number of samples.}

\item{data_folder}{Folder (relative path) to store datasets.}

\item{overwrite}{Logical (default = \code{FALSE}). Overwrites previous files.}

\item{id_var}{Character (default = \code{"ID"}). Name of ID column in dataset.}

\item{...}{Arguments passed to \code{\link[=fill_input]{fill_input()}}.}
}
\value{
A \code{tibble} with \code{samples} rows and an nm object object column \code{m} for
execution of the bootstrap.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Creates bootstrap datasets and returns corresponding \code{nm} objects. Requires
the necessary \code{rsample} splitting objects to be present. See examples.
}
\examples{

## The following only works inside an NMproject directory structure and
## and requires NONMEM installed
\dontrun{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))

d <- input_data(m1)

## in your dataset production script
d <- d \%>\%
  mutate(
    WT_C = cut(WT, breaks = 2, labels = FALSE),
    STRATA = paste(SEX, WT_C, sep = "_")
  )

d_id <- d \%>\% distinct(ID, STRATA)

set.seed(123)

## create large set of resamples (to enable simulation to grow
## without ruining seed)
bootsplits <- rsample::bootstraps(d_id, 100, strata = "STRATA")

dir.create("DerivedData", showWarnings = FALSE)
bootsplits \%>\% saveRDS("DerivedData/bootsplit_data.csv.RData")

## In a model development script, the following, performs a
## 100 sample bootstrap of model m1

m1_boot <- m1 \%>\% make_boot_datasets(samples = 100, overwrite = TRUE)

m1_boot$m \%>\% run_nm()

## the following bootstrap template will wait for results to complete
m1_boot$m \%>\% nm_list_render("Scripts/basic_boot.Rmd")
}

}
