% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_funs.R
\name{init_theta}
\alias{init_theta}
\alias{init_omega}
\alias{init_sigma}
\title{Get/set initial parameters}
\usage{
init_theta(m, replace, ...)

init_omega(m, replace, ...)

init_sigma(m, replace, ...)
}
\arguments{
\item{m}{An nm object.}

\item{replace}{Optional \code{tibble} for replacement.}

\item{...}{Additional arguments for mutating initial estimate NONMEM
subroutines.  See examples.}
}
\value{
If \code{replace} is specified returns an nm object with modified
\code{ctl_contents} field.  Otherwise returns a \code{tibble} or list of \code{tibble}s
with initial estimation information.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

These functions are useful to obtain and modify initial values of \verb{$THETA},
\verb{$OMEGA} and \verb{$SIGMA}.
}
\details{
It's easiest to learn this function by view examples, the vignette
and the demo \code{\link[=setup_nm_demo]{setup_nm_demo()}}. It is a good idea to view the resulting
\code{data.frame} to see the columns that are able to be manipulated.
}
\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))


m1 <- m1 \%>\%
  fill_input() \%>\%
  init_theta(init = c(-2, 0.5, 1)) \%>\%
  init_sigma(init = c(0.1, 0.1)) # \%>\%
  # run_nm()

init_theta(m1) ## display current $THETA in tibble-form
init_omega(m1) ## display current $OMEGA in tibble-form


## here we supply a named vector in a different order
m1 <- m1 \%>\% init_theta(init = c(KA = -2, V = 1))
m1 \%>\% dollar("THETA")

## can also manipulate other aspects (like the FIX column) similarly
m1 <- m1 \%>\% init_theta(init = c(KA = -2, V = 1),
                        FIX = c(KA = TRUE))
m1 \%>\% dollar("THETA")

## perturb all parameters by ~10\%
m1 <- m1 \%>\% init_theta(init = rnorm(length(init), mean = init, sd = 0.1))

m1 \%>\% dollar("THETA")

}
