% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_parameters.R
\name{update_parameters}
\alias{update_parameters}
\title{Update initial estimates to final estimates}
\usage{
update_parameters(ctl, from)
}
\arguments{
\item{ctl}{An nm object.}

\item{from}{Optional nm object. The completed object from which to extract
results.  If not specified, \code{from} will be taken to be \code{ctl}.}
}
\value{
An nm object with modified \code{ctl_contents} field.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))
             

m1 \%>\% dollar("THETA")

## requires NONMEM to be installed
\dontrun{
m1 \%>\% run_nm() \%>\% wait_finish()
m1 <- m1 \%>\% update_parameters()
m1 \%>\% dollar("THETA")
}
}
