% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post-run-summaries.R
\name{rr}
\alias{rr}
\title{Run record}
\usage{
rr(m, trans = TRUE)
}
\arguments{
\item{m}{An nm object.}

\item{trans}{Logical. If \code{TRUE} (default) will transform using control file
$THETA/OMEGA conventions.}
}
\value{
A \code{tibble} with NONMEM run results.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Displays the transformed parameters of a completed or running model.
Normally used inside of a diagnostic template, but can be useful for quickly
seeing parameter estimates of several models.
}
\section{NONMEM coding conventions used by NMproject}{


The convention for $THETA comments used by NMproject is
\verb{value ; name ; unit ; transformation}

e.g.
\verb{$THETA}
\verb{0.1    ; KA ; h-1 ; LOG}

The options for THETA transformations are: \code{LOG}, \code{LOGIT}, \code{RATIO} and
missing. \code{LOG} and \code{LOGIT} refer to log and logit transformed THETAs,
respectively where the parameters should be back-transformed for reporting.
\code{RATIO} refers to ratio data types, i.e. parameters that are positive and
have a meaningful zero. Most parameters like KA, CL, EMAX fall into this
category, but covariates effects which can go negative do not.  RSEs are
calculated for ratio data. Missing transformations are suitable for all other
parameters, here no RSEs will be calculated, only raw SE values will be
reported.

The convention for $OMEGA is similar but without a unit item:
\verb{value ; name ; transformation}

e.g.
\verb{$OMEGA}
\verb{0.1    ; IIV_KA ; LOG}

The options for OMEGA are either \code{LOG} or missing.  \code{LOG} indicating that the
individual parameter distribution is log normally distributions and should be
reported as a CV\% (and associated RSE\%) rather than as the raw NONMEM
estimate.

The convention for $OMEGA is just : \verb{value ; name}.
}

\section{THETA transformations using \code{trans = TRUE}}{


The value of FINAL and RSE\% (always accompanied with a \verb{\%} symbol in outputs)
in the returned \code{tibble} is the reported standard error (where applicable)
where \eqn{\theta} and \eqn{se(\theta)} are the NONMEM reported values of
parameters and standard errors, respectively:

\describe{
\item{\code{LOG}}{
\eqn{FINAL = exp(\theta), RSE = 100\sqrt(exp(se(\theta)^2) - 1)}
}
\item{\code{RATIO}}{
\eqn{FINAL = \theta, RSE = 100se(\theta)/\theta}
}
\item{\code{LOGIT}}{
\eqn{FINAL = 100/(1 + exp(-\theta)), SE = se(\theta)}
}
\item{missing}{
\eqn{FINAL = \theta, SE = se(\theta)}
}
}
}

\section{OMEGA transformations using \code{trans = TRUE}}{


The value of FINAL and RSE\% (always accompanied with a \verb{\%} symbol in outputs)
in the returned \code{tibble} is the reported standard error (where applicable)
where \eqn{\omega^2} and \eqn{se(\omega^2)} are the NONMEM reported values of
parameters and standard errors, respectively

\describe{
\item{\code{LOG}}{
\eqn{FINAL = 100\sqrt(exp(\omega^2) - 1), RSE = 100(se(\omega^2)/\omega^2)/2}
}
\item{missing}{
\eqn{FINAL = \omega^2, SE = se(\omega^2)}
}
}
}

\section{SIGMA transformations using \code{trans = TRUE}}{


The value of FINAL and RSE\% (always accompanied with a \verb{\%} symbol in outputs)
in the returned \code{tibble} is the reported standard error (where applicable)
where \eqn{\sigma^2} and \eqn{se(\sigma^2)} are the NONMEM reported values of
parameters and standard errors, respectively.  All sigmas are reported as
standard deviations.

\describe{
\item{all sigmas}{
\eqn{FINAL = \sqrt(\sigma^2), RSE = 100se(\sigma^2) / \sigma^2}
}
}
}

\examples{

## requires NONMEM to be installed
\dontrun{

rr(m1)

## compare m1 and m2

rr(c(m1, m2))
}
}
\seealso{
\code{\link[=nm_render]{nm_render()}}
}
