% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Co.LPM}
\alias{Co.LPM}
\title{Co-Lower Partial Moment
(Lower Left Quadrant 4)}
\usage{
Co.LPM(degree_lpm, x, y, target_x, target_y)
}
\arguments{
\item{degree_lpm}{integer; Degree for lower deviations of both variable X and Y.  \code{(degree_lpm = 0)} is frequency, \code{(degree_lpm = 1)} is area.}

\item{x}{a numeric vector.   \link{data.frame} or \link{list} type objects are not permissible.}

\item{y}{a numeric vector of equal length to \code{x}.   \link{data.frame} or \link{list} type objects are not permissible.}

\item{target_x}{numeric; Target for lower deviations of variable X.  Typically the mean of Variable X for classical statistics equivalences, but does not have to be.}

\item{target_y}{numeric; Target for lower deviations of variable Y.  Typically the mean of Variable Y for classical statistics equivalences, but does not have to be.}
}
\value{
Co-LPM of two variables
}
\description{
This function generates a co-lower partial moment for between two equal length variables for any degree or target.
}
\examples{
set.seed(123)
x <- rnorm(100) ; y <- rnorm(100)
Co.LPM(0, x, y, mean(x), mean(y))
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{https://www.amazon.com/dp/1490523995/ref=cm_sw_su_dp}
}
\author{
Fred Viole, OVVO Financial Systems
}
