% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOVA.R
\name{NNS.ANOVA}
\alias{NNS.ANOVA}
\title{NNS ANOVA}
\usage{
NNS.ANOVA(
  control,
  treatment,
  means.only = FALSE,
  confidence.interval = 0.95,
  tails = "Both",
  pairwise = FALSE,
  plot = TRUE,
  robust = FALSE
)
}
\arguments{
\item{control}{a numeric vector, matrix or data frame.}

\item{treatment}{\code{NULL} (default) a numeric vector, matrix or data frame.}

\item{means.only}{logical; \code{FALSE} (default) test whether difference in sample means only is zero.}

\item{confidence.interval}{numeric [0, 1]; The confidence interval surrounding the \code{control} mean, defaults to \code{(confidence.interval = 0.95)}.}

\item{tails}{options: ("Left", "Right", "Both").  \code{tails = "Both"}(Default) Selects the tail of the distribution to determine effect size.}

\item{pairwise}{logical; \code{FALSE} (default) Returns pairwise certainty tests when set to \code{pairwise = TRUE}.}

\item{plot}{logical; \code{TRUE} (default) Returns the boxplot of all variables along with grand mean identification and confidence interval thereof.}

\item{robust}{logical; \code{FALSE} (default) Generates 100 independent random permutations to test results, and returns / plots 95 percent confidence intervals along with robust central tendency of all results.}
}
\value{
Returns the following:
\itemize{
\item{\code{"Control Mean"}} \code{control} mean.
\item{\code{"Treatment Mean"}} \code{treatment} mean.
\item{\code{"Grand Mean"}} mean of means.
\item{\code{"Control CDF"}} CDF of the \code{control} from the grand mean.
\item{\code{"Treatment CDF"}} CDF of the \code{treatment} from the grand mean.
\item{\code{"Certainty"}} the certainty of the same population statistic.
\item{\code{"Lower Bound Effect"} and \code{"Upper Bound Effect"}} the effect size of the \code{treatment} for the specified confidence interval.
\item{\code{"Robust Certainty Estimate"}} and \code{"Lower 95 CI"}, \code{"Upper 95 CI"} are the robust certainty estimate and its 95 percent confidence interval after permutations if \code{robust = TRUE}.
}
}
\description{
Analysis of variance (ANOVA) based on lower partial moment CDFs for multiple variables, evaluated at multiple quantiles (or means only).  Returns a degree of certainty to whether the population distributions (or sample means) are identical, not a p-value.
}
\examples{
 \dontrun{
### Binary analysis and effect size
set.seed(123)
x <- rnorm(100) ; y <- rnorm(100)
NNS.ANOVA(control = x, treatment = y)

### Two variable analysis with no control variable
A <- cbind(x, y)
NNS.ANOVA(A)

### Multiple variable analysis with no control variable
set.seed(123)
x <- rnorm(100) ; y <- rnorm(100) ; z <- rnorm(100)
A <- cbind(x, y, z)
NNS.ANOVA(A)
}
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments" (ISBN: 1490523995)

Viole, F. (2017) "Continuous CDFs and ANOVA with NNS"  \doi{10.2139/ssrn.3007373}
}
\author{
Fred Viole, OVVO Financial Systems
}
