% Generated by roxygen2 (4.0.2): do not edit by hand
\name{BoundingRA}
\alias{BoundingRA}
\title{Computes an intermediate multivariate normal correlation matrix before using
the NORTA approach.}
\usage{
BoundingRA(cor_matrix, invcdfnames, paramslists, m1 = 60, c1 = 2, c2 = 1,
  delta1 = 1e-04, sigma0 = 0.01, epsilon = 1e+50, maxit = 1000)
}
\arguments{
\item{cor_matrix}{The specified input correlation matrix.}

\item{invcdfnames}{A character sequence of the marginals' inverse cdf names.}

\item{paramslists}{A list contains lists of params of the marginals as the
 same order as \code{invcdfnames}.}

\item{m1}{The initial sample size.}

\item{c1}{The sample-size multiplier(c1>1).}

\item{c2}{The step-size multiplier(c2>0).}

\item{delta1}{The initial step size(detla1>0).}

\item{sigma0}{The standard error tolerance.}

\item{epsilon}{The initial error tolerance.}

\item{maxit}{The maximum number of numerical searches.}
}
\value{
An intermediate normal correalation matrix of the same size as
 \code{cor_matrix}.
}
\description{
The function computes an intermediate multivariate correlation matrix with a
specific RA(Retrospective Approximation) algorithm called bounding RA.
}
\details{
The function computes an intermediate multivariate correlation matrix with a
specific RA(Retrospective Approximation) algorithm called bounding RA.Then the
result matrix will be used to applying the NORTA approach to get \code{n}
observations which have specified marginals and target correlation matrix
\code{cor_matrix}.
}
\note{
In this implementation of the NORTA approach with bounding RA algorithm
 according to the reference paper, the initial sample  size is adjusted from
 40 to 60, the other parameters remain the same. And the third choice of
 random seeds \code{w_bar} is used for efficiency while the Appendix of the paper
 uses the first choice.
}
\examples{
\dontrun{
invcdfnames <- c("qt","qpois","qnorm")
paramslists <- list(
               m1 = list(df = 3),
               m2 = list(lambda = 5),
               m3 = NULL  # it means list(mean = 0, sd = 1)
                 )
cor_matrix <- matrix(c(1,0.5,-0.3,0.5,1,0.4,-0.3,0.4,1), 3)
Sigma <- BoundingRA(cor_matrix,invcdfnames,paramslists)
Sigma
invcdfnames <- c("qunif","qunif","qunif")
paramslists <- list(
               m1 = NULL, #it means list(min = 0, max = 1)
               m2 = NULL,
               m3 = NULL
              )
cor_matrix <- matrix(c(1,0.5,-0.3,0.5,1,0.4,-0.3,0.4,1), 3)
Sigma <- BoundingRA(cor_matrix,invcdfnames,paramslists)
Sigma
#NB:For element 0.5 in cor_matrix, the true root should be around 2*sin(0.5*3.14/6).
res <- sapply(c(0.5,-0.3,0.4), function(x){2*sin(x*pi/6)})
trueroots <- diag(1/2,3,3)
trueroots[upper.tri(trueroots)] <- res
trueroots <- trueroots + t(trueroots)
trueroots
abserrors <- abs(Sigma - trueroots)
abserrors
}
}
\author{
Po Su
}
\references{
Huifen Chen, (2001) Initialization for NORTA: Generation of
 Random Vectors with Specified Marginals and Correlations. INFORMS Journal on
 Computing \bold{13(4):312-331.}
}
\seealso{
\code{\link{genNORTARA}}, \code{\link{valid_input_cormat}},
 \code{\link{check_input_cormat}}
}

