% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{mTAR.pred}
\alias{mTAR.pred}
\title{Prediction of A Fitted Multivariate TAR Model}
\usage{
mTAR.pred(model, orig, h = 1, iterations = 3000, ci = 0.95, output = TRUE)
}
\arguments{
\item{model}{multivariate TAR model.}

\item{orig}{forecast origin.}

\item{h}{forecast horizon.}

\item{iterations}{number of iterations.}

\item{ci}{confidence level.}

\item{output}{a logical value for output.}
}
\value{
mTAR.pred returns a list with components:
\item{model}{the multivariate TAR model.}
\item{pred}{prediction.}
\item{Ysim}{fitted \code{y}.}
}
\description{
Prediction of a fitted multivariate TAR model.
}
\examples{
phi1=matrix(c(0.5,0.7,0.3,0.2),2,2)
phi2=matrix(c(0.4,0.6,0.5,-0.5),2,2)
sigma1=matrix(c(1,0,0,1),2,2)
sigma2=matrix(c(1,0,0,1),2,2)
c1=c(0,0)
c2=c(0,0)
delay=c(1,1)
y=mTAR.sim(100,0,phi1,phi2,sigma1,sigma2,c1,c2,delay,ini=500)
est=mTAR.est(y$series,c(1,1),0,delay)
pred=mTAR.pred(est,100,1,300,0.90,TRUE)
}
