% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\name{turtles2spdf}
\alias{turtles2spdf}
\alias{turtles2spdf,agentMatrix-method}
\title{From \code{agentMatrix} to \code{SpatialPointsDataFrame}}
\usage{
turtles2spdf(turtles)

\S4method{turtles2spdf}{agentMatrix}(turtles)
}
\arguments{
\item{turtles}{\code{AgentMatrix} object representing the moving \code{agents}.}
}
\value{
\code{SpatialPointsDataFrame} object representing the moving \code{agents}
       (coordinates and data)
        as contained in \code{turtles}.
}
\description{
Convert an \code{agentMatrix} object into a \code{SpatialPointsDataFrame} object.
}
\examples{
t1 <- createTurtles(n = 10, coords = cbind(xcor = 1:10, ycor = 1:10))
sp1 <- turtles2spdf(turtles = t1)


}
\author{
Sarah Bauduin
}
