% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agentset-functions.R
\docType{methods}
\name{NLwith}
\alias{NLwith}
\alias{with}
\alias{NLwith,matrix,worldMatrix,missing-method}
\alias{NLwith,matrix,worldArray,character-method}
\alias{NLwith,agentMatrix,missing,character-method}
\title{\code{Agents} with}
\usage{
NLwith(agents, world, var, val)

\S4method{NLwith}{matrix,worldMatrix,missing}(agents, world, val)

\S4method{NLwith}{matrix,worldArray,character}(agents, world, var, val)

\S4method{NLwith}{agentMatrix,missing,character}(agents, var, val)
}
\arguments{
\item{agents}{Matrix (\code{ncol} = 2) with the first column \code{pxcor} and the second
              column \code{pycor} representing the \code{patches} coordinates, or

              \code{AgentMatrix} object representing the moving \code{agents}.}

\item{world}{\code{WorldMatrix} or \code{worldArray} object.}

\item{var}{Character. The name of the selected \code{agents} variable.
If \code{agents} are \code{patches} and the \code{world} is a
\code{worldMatrix} object, \code{var} must not be provided. If
\code{agents} are \code{patches} and the \code{world} is a \code{worldArray}
object, \code{var} is the name of the layer to use to define the \code{patches}
values. If \code{agents} are \code{turtles}, \code{var} is one of
the \code{turtles}' variable and can be equal to \code{xcor},
\code{ycor}, any of the variables created when \code{turtles} were created,
as well as any variable created using \code{turtlesOwn()}.}

\item{val}{Numeric or character. Vector of any length.}
}
\value{
Matrix (\code{ncol} = 2) with the first column \code{pxcor} and the second column
        \code{pycor} representing the coordinates of the \code{patches} among the \code{agents}
        which have their variable
        equals to any \code{val}, or

        \code{AgentMatrix} representing the \code{turtles} among the \code{agents}
        which have their variable
        \code{var} equals to any \code{val}.
}
\description{
Report the \code{patches} or the \code{turtles} among \code{agents} which have their variable
equals to specific values.
}
\details{
\code{world} must not be provided if \code{agents} are \code{turtles}.

         This is equivalent in R to subsetting.
}
\examples{
# Patches
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4,
                          data = sample(1:5, size = 25, replace = TRUE))
plot(w1)
p2 <- NLwith(agents = patches(w1), world = w1, val = 2)

# Turtles
t1 <- createTurtles(n = 5, coords = randomXYcor(w1, n = 5),
                    breed = c("sheep", "sheep", "wolf", "sheep", "sheperd"))
t2 <- NLwith(agents = t1, var = "breed", val = "sheep")
t3 <- NLwith(agents = t1, var = "breed", val = c("sheep", "wolf"))


}
\references{
Wilensky, U. 1999. NetLogo. \url{http://ccl.northwestern.edu/netlogo/}.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#with}
}
\author{
Sarah Bauduin
}
