% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkChange.r
\name{NetworkChange}
\alias{NetworkChange}
\title{Changepoint analysis of a degree-corrected multilinear tensor model}
\usage{
NetworkChange(Y, R = 2, m = 1, initial.s = NULL, mcmc = 100,
  burnin = 100, verbose = 0, thin = 1, reduce.mcmc = NULL,
  degree.normal = "eigen", UL.Normal = "Orthonormal", DIC = FALSE,
  Waic = FALSE, marginal = FALSE, plotUU = FALSE, plotZ = FALSE,
  constant = FALSE, b0 = 0, B0 = 1, c0 = NULL, d0 = NULL, u0 = NULL,
  u1 = NULL, v0 = NULL, v1 = NULL, a = NULL, b = NULL)
}
\arguments{
\item{Y}{Reponse tensor}

\item{R}{Dimension of latent space. The default is 2.}

\item{m}{Number of change point.
If \code{m = 0} is specified, the result should be the same as \code{NetworkStatic}.}

\item{initial.s}{The starting value of latent state vector. The default is
sampling from equal probabilities for all states.}

\item{mcmc}{The number of MCMC iterations after burnin.}

\item{burnin}{The number of burn-in iterations for the sampler.}

\item{verbose}{A switch which determines whether or not the progress of the
sampler is printed to the screen.  If \code{verbose} is greater than 0 the
iteration number, the \eqn{\beta} vector, and the error variance are
printed to the screen every \code{verbose}th iteration.}

\item{thin}{The thinning interval used in the simulation.  The number of
MCMC iterations must be divisible by this value.}

\item{reduce.mcmc}{The number of reduced MCMC iterations for marginal likelihood computations.
If \code{reduce.mcmc = NULL}, \code{mcmc/thin} is used.}

\item{degree.normal}{A null model for degree correction. Users can choose "NULL", "eigen" or "Lsym."
"NULL" is no degree correction. "eigen" is a principal eigen-matrix consisting of
the first eigenvalue and the corresponding eigenvector. "
Lsym" is a modularity matrix. Default is "eigen."}

\item{UL.Normal}{Transformation of sampled U. Users can choose "NULL", "Normal" or "Orthonormal."
"NULL" is no normalization. "Normal" is the standard normalization.
"Orthonormal" is the Gram-Schmidt orthgonalization. Default is "NULL."}

\item{DIC}{If \code{DIC = TRUE}, the deviation information criterion is computed.}

\item{Waic}{If \code{Waic = TRUE}, the Watanabe information criterion is computed.}

\item{marginal}{If \code{marginal = TRUE}, the log marignal likelihood is computed using the method of Chib (1995).}

\item{plotUU}{If \code{plotUU = TRUE} and \code{verbose > 0},
then the plot of the latent space will be
printed to the screen at every \code{verbose}th iteration.
The default is \code{plotUU = FALSE}.}

\item{plotZ}{If \code{plotZ = TRUE} and \code{verbose > 0},
then the plot of the degree-corrected input matrix will be
printed to the screen with the sampled mean values at every \code{verbose}th iteration.
The default is \code{plotUU = FALSE}.}

\item{constant}{If \code{constant = TRUE}, constant parameter is sampled
and saved in the output as attribute \code{bmat}. Default is \code{constant = FALSE}.}

\item{b0}{The prior mean of \eqn{\beta}. This must be a scalar. The default value is 0.}

\item{B0}{The prior variance of \eqn{\beta}. This must be a scalar.  The default value is 1.}

\item{c0}{= 0.1}

\item{d0}{= 0.1}

\item{u0}{\eqn{u_0/2} is the shape parameter for the inverse
Gamma prior on variance parameters for U. The default is 10.}

\item{u1}{\eqn{u_1/2} is the scale parameter for the
inverse Gamma prior on variance parameters for U.
The default is 1.}

\item{v0}{\eqn{v_0/2} is the shape parameter for the inverse
Gamma prior on variance parameters for V.
The default is 10.}

\item{v1}{\eqn{v_1/2} is the scale parameter for the
inverse Gamma prior on variance parameters for V.
The default is the time length of Y.}

\item{a}{\eqn{a} is the shape1 beta prior for transition probabilities. By default,
the expected duration is computed and corresponding a and b values are assigned. The expected
duration is the sample period divided by the number of states.}

\item{b}{\eqn{b} is the shape2 beta prior for transition probabilities. By default,
the expected duration is computed and corresponding a and b values are assigned. The expected
duration is the sample period divided by the number of states.}
}
\value{
An mcmc object that contains the posterior sample. This object can
be summarized by functions provided by the coda package. The object
contains an attribute \code{Waic.out} that contains results of WAIC and the log-marginal
likelihood of the model (\code{logmarglike}). The object
also contains an attribute \code{prob.state} storage matrix that contains the
probability of \eqn{state_i} for each period
}
\description{
NetworkChange implements Bayesian multiple changepoint models to network time series data
using a degree-corrected multilinear tensor decomposition method
}
\examples{

   \dontrun{
   set.seed(1973)
   ## Generate an array (30 by 30 by 40) with block transitions
   from 2 blocks to 3 blocks
   Y <- MakeBlockNetworkChange(n=10, T=40, type ="split")
   G <- 100 ## Small mcmc scans to save time

   ## Fit multiple models for break number detection using Bayesian model comparison
   out0 <- NetworkStatic(Y, R=2, mcmc=G, burnin=G, verbose=G, Waic=TRUE)
   out1 <- NetworkChange(Y, R=2, m=1, mcmc=G, burnin=G, verbose=G, Waic=TRUE)
   out2 <- NetworkChange(Y, R=2, m=2, mcmc=G, burnin=G, verbose=G, Waic=TRUE)
   out3 <- NetworkChange(Y, R=2, m=3, mcmc=G, burnin=G, verbose=G, Waic=TRUE)
   outlist <- list(out0, out1, out2, out3)

   ## The most probable model given break number 0 to 3 and data is out1 according to WAIC 
   WaicCompare(outlist)

   ## plot latent node positions
   plotU(out1)
 
   ## plot layer-specific network generation rules
   plotV(out1)
   }
}
\references{
Jong Hee Park and Yunkyun Sohn. 2017. "Detecting Structural Change
in Network Time Series Data using Bayesian Inference." Working Paper.

Peter D. Hoff 2011. "Hierarchical Multilinear Models for Multiway Data."
\emph{Computational Statistics \& Data Analysis}. 55: 530-543.

Siddhartha Chib. 1998. "Estimation and comparison of multiple change-point models."
\emph{Journal of Econometrics}. 86: 221-241.

Sumio Watanabe. 2010. "Asymptotic equivalence of Bayes cross validation and widely
applicable information criterion in singular learning theory."
\emph{Journal of Machine Learning Research}. 11: 3571-3594.
Siddhartha Chib. 1995. ``Marginal Likelihood from the Gibbs Output.''
\emph{Journal of the American Statistical Association}. 90: 1313-1321.
}
\seealso{
\code{\link{NetworkStatic}}
}
