% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nd_centrality.R
\name{nd.centrality}
\alias{nd.centrality}
\title{Centrality Distance}
\usage{
nd.centrality(
  A,
  out.dist = TRUE,
  mode = c("Degree", "Close", "Between"),
  directed = FALSE
)
}
\arguments{
\item{A}{a list of length \eqn{N} containing \eqn{(M\times M)} adjacency matrices.}

\item{out.dist}{a logical; \code{TRUE} for computed distance matrix as a \code{dist} object.}

\item{mode}{type of node centrality definitions to be used.}

\item{directed}{a logical; \code{FALSE} as symmetric, undirected graph.}
}
\value{
a named list containing \describe{
\item{D}{an \eqn{(N\times N)} matrix or \code{dist} object containing pairwise distance measures.}
\item{features}{an \eqn{(N\times M)} matrix where rows are node centralities for each graph.}
}
}
\description{
Centrality is a core concept in studying the topological structure of
complex networks, which can be either defined for each node or edge.
\code{nd.centrality} offers 3 distance measures on node-defined centralities.
See this \href{https://en.wikipedia.org/wiki/Centrality}{Wikipedia page} for more
on network/graph centrality.
}
\examples{
\donttest{
## load example data
data(graph20)

## use 3 types of centrality measures
out1 <- nd.centrality(graph20, out.dist=FALSE,mode="Degree")
out2 <- nd.centrality(graph20, out.dist=FALSE,mode="Close")
out3 <- nd.centrality(graph20, out.dist=FALSE,mode="Between")

## visualize
opar = par(no.readonly=TRUE)
par(mfrow=c(1,3), pty="s")
image(out1$D[,20:1], main="Degree", col=gray(0:32/32), axes=FALSE)
image(out2$D[,20:1], main="Close", col=gray(0:32/32), axes=FALSE)
image(out3$D[,20:1], main="Between", col=gray(0:32/32), axes=FALSE)
par(opar)
}

}
\references{
\insertRef{roy_modeling_2014}{NetworkDistance}
}
