% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{rmse}
\alias{rmse}
\title{Root Mean Square Error}
\usage{
rmse(base, test)
}
\arguments{
\item{base}{Base (or full) model to be evaulated against}

\item{test}{Reduced (or testing) model (e.g., a sparse correlation or covariance matrix)}
}
\value{
RMSE value. Lower values suggest more similarity between the full and sparse model
}
\description{
Computes the root mean square error of a sparse model to a full model
}
\examples{
A1 <- solve(cov(neoOpen))

A2 <- LoGo(neoOpen)

root <- rmse(A1, A2)

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
