% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.coverage.R
\name{net.coverage}
\alias{net.coverage}
\title{Network Coverage}
\usage{
net.coverage(A, nodes)
}
\arguments{
\item{A}{An adjacency matrix}

\item{nodes}{Subset of nodes to examine the coverage of the network}
}
\value{
Returns a list containing:

\item{mean}{The average distance from the subset of nodes to all other nodes in the network}

\item{sd}{The standard deviation of distance from the subset of nodes to all other nodes in the network}

\item{range}{The range of distance from the subset of nodes to all other nodes in the network}
}
\description{
Computes the mean distance across a subset of nodes in a network.
This measure can be used to identify the effectiveness of a subset of nodes'
coverage of the network space
}
\examples{
A <- TMFG(neoOpen)$A

nodes <- c(1,3,5,7,11,13,17,19,23,29,31,37,41,43,47)

result <- net.coverage(A, nodes)

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
Mathias Benedek <mathias.benedek@uni-graz.at>
}
