% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{guineapig_neurotransmission_df}
\alias{guineapig_neurotransmission_df}
\title{Neurotransmission in Guinea Pig Brains}
\format{
A data frame with 346 observations and 1 variable:
\describe{
  \item{y}{Numeric: Peak amplitude of spontaneous synaptic currents (pA or similar units)}
}
}
\source{
Data taken from the boot package version 1.3-31. Original study:
Paulsen, O. and Heggelund, P. (1994) The quantal size at retinogeniculate synapses
determined from spontaneous and evoked EPSCs in guinea-pig thalamic slices.
\emph{Journal of Physiology}, 480, 505--511.
}
\usage{
data(guineapig_neurotransmission_df)
}
\description{
This dataset, guineapig_neurotransmission_df, is a data frame containing measurements
of spontaneous current amplitudes recorded from individual brain cells in adult guinea pigs.
The study investigated whether synaptic transmission occurs in quantal units, which would
manifest as multimodal amplitude distributions with regularly spaced peaks.
}
\details{
The dataset name has been kept as 'guineapig_neurotransmission_df' to avoid confusion
with other datasets in the R ecosystem. This naming convention helps distinguish
this dataset as part of the NeuroDataSets package. The suffix 'df' indicates
that the dataset is a data frame. The original content has not been modified.
}
