% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modues.R
\name{mi_cont}
\alias{mi_cont}
\title{Continuous  Mutual Information}
\usage{
mi_cont(df, k = 3, algo = "ksg1")
}
\arguments{
\item{df}{Datafame of type Integer}

\item{k}{Integer argument, the number of neighbours.}

\item{algo}{String argument specifies the algorithm use ("ksg1", "ksg2"), as tow propositions of Kraskov approximation are provided. The first one ("ksg1") is used by default}
}
\description{
Continuous  Mutual Information
}
\details{
Computes the   Mutual Information between columns of a dataframe using the Kraskov approximation.
}
\examples{
library (timeSeries)
library (NlinTS)
#load data
data = LPP2005REC
print (mi_cont (data, 3, 'ksg1'))
print (mi_cont (data, 3, 'ksg2'))
}
\references{
{
  \insertRef{kraskov2004estimating}{NlinTS}
}
}
