% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NonProbEst.R
\name{model_assisted}
\alias{model_assisted}
\title{Calculates a model assisted estimation}
\usage{
model_assisted(sample_data, weights, full_data, covariates, estimated_var,
  estimate_mean = FALSE, positive_label = NULL, algorithm = "glm",
  proc = NULL, ...)
}
\arguments{
\item{sample_data}{Data frame containing the sample.}

\item{weights}{Vector containing the sample weights.}

\item{full_data}{Data frame containing all the individuals contained in the population.}

\item{covariates}{String vector specifying the common variables to use for training.}

\item{estimated_var}{String specifying the variable to estimate.}

\item{estimate_mean}{Boolean specifying whether the mean estimation should be returned. Otherwise, the total estimation is returned by default.}

\item{positive_label}{String specifying the label to be considered positive if the estimated variable is categorical. Leave it as the default NULL otherwise.}

\item{algorithm}{A string specifying which classification or regression model to use (same as caret's method).}

\item{proc}{A string or vector of strings specifying if any of the data preprocessing techniques available in \link[caret]{train} function from `caret` package should be applied to data prior to the propensity estimation. By default, its value is NULL and no preprocessing is applied.}

\item{...}{Further parameters to be passed to the \link[caret]{train} function.}
}
\value{
The population total estimation (or mean if specified by the `estimate_mean` parameter).
}
\description{
It uses the model assisted estimator introduced by Särndal et al. (1992).
}
\details{
Training of the models is done via the `caret` package. The algorithm specified in \code{algorithm} must match one of the names in the list of algorithms supported by `caret`.
}
\examples{
#Simple example with default parameters
covariates = c("education_primaria", "education_secundaria",
   "education_terciaria", "age", "sex", "language")
model_assisted(sampleNP, nrow(population) / nrow(sampleNP),
   population, covariates, "vote_gen")
}
\references{
Särndal, C. E., Swensson, B., & Wretman, J. (1992). \emph{Model assisted survey sampling.} Springer, New York.
}
