% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SvmFit.R
\name{SvmFit}
\alias{SvmFit}
\title{support vector machine}
\usage{
SvmFit(featuredata, groupdata, kernel = "radial", cost = 1, gamma = NULL,
  crossvalid = TRUE, k = 5, tune = FALSE, pred = TRUE,
  pfeaturedata = featuredata, pgroupdata = groupdata, rocplot = TRUE,
  saveoutput = FALSE, outputname = "svm", ...)
}
\arguments{
\item{featuredata}{featuredata A data frame in the featuredata format. 
 This is a dataframe with metabolites in columns and samples in rows.
Unique sample names should be provided as row names.
See NormalizeMets Vignette for details.}

\item{groupdata}{A vector with group names.}

\item{kernel}{The kernel used. The default is the radial basis function with type C-classification.}

\item{cost}{of constraint violation, defaults to 1.}

\item{gamma}{parameter used for the kernel}

\item{crossvalid}{A logical indicating whether cross-validation needs to be conducted}

\item{k}{An integer specifying the k-fold cross-validation. Default is set to 5.}

\item{tune}{A logical with the default set to FALSE. If TRUE, a grid search will be 
conducted to tune the hyperparameters, over parameter ranges supplied by the user.}

\item{pred}{whether the predictions should be made}

\item{pfeaturedata}{The test dataset for the predictions. The default is featuredata}

\item{pgroupdata}{The test groupdata for the predictions. The default is groupdata}

\item{rocplot}{A logical indicating whether a receiver operating characteristic curve needs to be plotted, 
along with the area under the curve (AUC) printed.}

\item{saveoutput}{A logical indicating whether the outputs should be saved in the format
\code{\link[e1071]{write.svm}}}

\item{outputname}{The name of the output file if the output has to be saved.}

\item{...}{Arguments to be passed on to other methods.}
}
\value{
If tune=FALSE, an object of class "svm" \code{\link[e1071]{svm}} 
containing the fitted model or if tune=TRUE, 
an object of class \code{\link[e1071]{tune}}
}
\description{
Classification using support vector machine (svm) algorithm
}
\examples{
 data(alldataC)
SvmFit(featuredata=alldataC$featuredataC, 
       groupdata=alldataC$groupdataC,
       crossvalid=TRUE,
       k=5,
       rocplot = TRUE)

}
\seealso{
\code{\link[e1071]{tune}}
}
\author{
Alysha M De Livera, Gavriel Olshansky
}
