% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nretention.r
\name{calc_nleach}
\alias{calc_nleach}
\title{Calculate the N leaching}
\usage{
calc_nleach(
  B_SOILTYPE_AGR,
  B_LU_BRP,
  B_GWL_CLASS,
  D_NLV,
  B_AER_CBS,
  leaching_to
)
}
\arguments{
\item{B_SOILTYPE_AGR}{(character) The type of soil}

\item{B_LU_BRP}{(numeric) The crop code (gewascode) from the BRP}

\item{B_GWL_CLASS}{(character) The groundwater table class}

\item{D_NLV}{(numeric) The N supplying capacity of a soil (kg N ha-1 jr-1) calculated by \code{\link{calc_nlv}}}

\item{B_AER_CBS}{(character) The agricultural economic region in the Netherlands (CBS, 2016)}

\item{leaching_to}{(character) whether it computes N leaching to groundwater ("gw") or to surface water ("ow")}
}
\value{
The potential nitrogen leaching from the soil originating from soil nitrogen mineralization processes. A numeric value.
}
\description{
This function calculates the potential N leaching of a soil.
}
\examples{
calc_nleach('dekzand',265,'GtIII',145,'Zuidwest-Brabant','gw')
calc_nleach('rivierklei',1019,'GtIV',145,'Rivierengebied','ow')

}
