# Set column comments from specified tables in an ODB connection
# Author : Sylvain Mareschal
"odb.comments<-" = function(
		odb,
		tableNames,
		columnNames,
		value
		)
	{
	# Class checks
	if (!is(odb, "odb")) {
		stop("'odb' must be an 'odb' object")
	}
	validObject(odb)
	
	# Encoding
	value = iconv(value, to="UTF-8")
	
	# Recycling
	maxLength = max(length(tableNames), length(columnNames), length(value))
	columnNames = rep(columnNames, length.out=maxLength)
	tableNames = rep(tableNames, length.out=maxLength)
	value = rep(value, length.out=maxLength)
	
	# XML content
	tree = xmlParse(paste(odb@directory, "content.xml", sep="/"))
	
	for(i in 1:maxLength) {
		# Initialization
		path = "/office:document-content/office:body/office:database"
		parent = getNodeSet(tree, path)[[1]]
		nodes = list(
			"table-representations" = character(0),
			"table-representation" = c("db:name"=tableNames[i]),
			"columns" = character(0),
			"column" = c("db:name"=columnNames[i])
		)
		
		# Recursive node building
		for(level in 1:length(nodes)) {
			# Node retrieval
			if (length(nodes[[level]]) == 1) {
				xpath = paste(sep="",
					paste("db", names(nodes)[level], sep=":"),
					"[@",
					names(nodes[[level]]),
					"=\"",
					nodes[[level]],
					"\"]"
					)
			} else {
				xpath = paste("db", names(nodes)[level], sep=":")
			}
			
			path = paste(path, xpath, sep="/")
			child = getNodeSet(tree, path)
			
			if (length(child) == 0) {
				# New node
				child = list(
					newXMLNode(
						name = names(nodes)[level],
						attrs = nodes[[level]],
						parent = parent,
						namespace = "db"
					)
				)
			}
			
			parent = child[[1]]
		}
		node = parent
		
		# Updates the node
		xmlAttrs(node) = c("db:help-message"=value[i])
	}
	
	# Save XML to file
	saveXML(tree, file=paste(odb@directory, "content.xml", sep="/"))
	
	return(odb)
}

