% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimHensonRT.r
\name{opiPresent_for_SimHensonRT}
\alias{opiPresent_for_SimHensonRT}
\title{opiPresent_for_SimHensonRT}
\arguments{
\item{stim}{A list that contains at least:
\itemize{
\item \code{level} which is the stim value in cd/\eqn{\mbox{m}^2}{m^2}.
}}

\item{fpr}{false positive rate for the FoS curve (range 0..1).}

\item{fnr}{false negative rate for the FoS curve (range 0..1).}

\item{tt}{mean of the assumed FoS curve in dB.}

\item{dist}{The distance of the stimulus level from \code{tt} in appropriate units (same as \code{rtData$Dist}).}

\item{...}{Any other parameters you like, they are ignored.}
}
\value{
A list with elements:
\itemize{
\item \code{err} \code{NULL} if no error, a string message otherwise.
\item \code{seen} \code{TRUE} or \code{FALSE}.
\item \code{time} The response time.
}
}
\description{
Determine the response to a stimuli by sampling from a cumulative Gaussian
Frequency-of-Seeing (FoS) curve (also known as the psychometric function).

For internal use only, use \code{opiPresent()}.
}
\details{
As the response time returned for a false positive is determined
separately from a positive response, we first check for a false response.
If there is no false response, we use the FoS formula
\deqn{1-\mbox{pnorm}(x, \mbox{tt}, \mbox{pxVar})}
where \code{x} is the stimulus value in dB, and \code{pxVar} is
\deqn{\min(\mbox{cap}, e^{A\times\mbox{tt}+B}).}
The ceiling \code{cap} is set with the call to
\code{opiInitialize}, and \code{A} and \code{B} are from Table 1 in Henson
et al (2000), also set in the call to \code{opiInitialise} using the \code{type} parameter.

Thus, this function is the same as for \code{SimHenson}, but
reaction times are determined by sampling from \code{rtData} as passed to
\code{opiInitialize}.  The \code{dist} parameter is the distance of the
stimulus level from the true threshold, and should be in the same units as
the \code{Dist} column of \code{rtData}. The default is just the straight
difference between the stimulus level and the true threshold, but you might
want it scaled somehow to match \code{rtData}.
}
\examples{
    # Stimulus is Size III white-on-white as in the HFA
chooseOpi("SimHensonRt")
data(RtSigmaUnits)
res <- opiInitialize(type = "C", cap = 6, rtData = RtSigmaUnits)
if (!is.null(res$err))
  stop(paste("opiInitialize() failed:", res$err))

dist <- (10 - 30) / min(exp(-0.098 * 30 + 3.62), 6)
result <- opiPresent(stim = list(level = dbTocd(20)), tt = 30, fpr = 0.15, fnr = 0.01, dist=dist)
print(result, quote = FALSE)

res <- opiClose()
if (!is.null(res$err))
  stop(paste("opiClose() failed:", res$err))


if (!is.null(opiClose()))
  warning("opiClose() failed")
}
