% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryClasses.R
\name{summaryClasses}
\alias{summaryClasses}
\title{Occurrence of Classes by Size}
\usage{
summaryClasses(subcascades = NULL)
}
\arguments{
\item{subcascades}{A Subcascades object as it is returned by \code{\link{subcascades}}-function.
The Subcascades object is made up of a list of matrices.
Each matrix comprises the evaluation results of cascades of a specific length and
is sorted row-wise according to the achieved minimal classwise sensitivities of the cascades (decreasing).
The rownames show the class order by a character string of type '1>2>3' and the entries the sensitivity for each position of the cascade.}
}
\value{
A matrix summarizing the overview characteristics of the Subcascades object.
}
\description{
\code{summaryClasses} returns the occurrence of classes by size
}
\details{
This function gives an overview of the classes of the Subcascades object. For each length in
the Subcascades object the occurence of classes is given.
}
\examples{
library(TunePareto)
data(esl)
data = esl$data
labels = esl$labels
foldList = generateCVRuns(labels  = labels,
                          ntimes      = 2,
                          nfold       = 2,
                          leaveOneOut = FALSE,
                          stratified  = TRUE)
genMap = gen.predictionMap(data, labels, foldList = foldList, 
classifier = tunePareto.svm(), kernel='linear')
# generate Subcascades object
subcascades = subcascades(genMap,thresh=0.7)

summaryClasses(subcascades)


}
\seealso{
\code{\link{subcascades}}, \code{\link{summarySubcascades}}, \code{\link{summaryGroupwise}}
}
