% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{LShannon}
\alias{LShannon}
\title{A function to compute Shannon-Wiener local diversity (entropy) index}
\usage{
LShannon(x)
}
\arguments{
\item{x}{- an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a population group, within 
spatial units. The number of columns should be greater than 1 (at least 2 
population groups are required). You should not include a column with total 
population in each unit, because this will be interpreted as a group.}
}
\value{
Local Shannon-Wiener diversity index
}
\description{
The Shannon-Wiener diversity index is based on 
the notion of entropy and measures population heterogeneity.
}
\examples{
x <- segdata@data[ ,1:2]
LShannon(x) 
}
\references{
Shannon C. E. (1948) \emph{A mathematical theory 
of communication}. Bell System Technical Journal (27)
}
\seealso{
Other local indices: \code{\link{LQ}}, 
\code{\link{HLoc}}, \code{\link{LSimpson}}
}

