% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{Atkinson}
\alias{Atkinson}
\title{A function to compute Atkinson segregation index}
\usage{
Atkinson (x, delta = 0.5)
}
\arguments{
\item{x}{- an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a group within 
spatial units. The number of columns should be greater than 1 (at least 2 
groups are required). You should not include a column with total 
population, because this will be interpreted as a group.}

\item{delta}{- an inequality aversion parameter}
}
\value{
a numeric vector containing the Atkinson's segregation index value for 
each group
}
\description{
The spatial version of Atkinson inequality index is based on 
Lorenz curves. The user can decide wich part of the curve contributes more 
to the index, by choosing the value of the shape parameter, delta.
}
\examples{
x <- segdata@data[ ,7:8]
Atkinson(x) 
Atkinson(x, 0.1)
Atkinson(x, delta = 0.9)
}
\references{
James, D. and K. E. Taeuber (1985)  \emph{ Measures 
of Segregation}. Sociological Methodology 15, pp. 1-32
}
\seealso{
One-group evenness indices: 
\code{\link{ISDuncan}}, \code{\link{Gini}}, \code{\link{Gorard}}, 
\code{\link{HTheil}}, '\code{\link{ISWong}}, \code{\link{ISMorrill}},
\code{\link{ISMorrillK}}

Between groups dissimilarity indices: 
\code{\link{DIDuncan}}, \code{\link{Gini2}}, 
\code{\link{DIMorrill}}, \code{\link{DIMorrillK}}, \code{\link{DIWong}}
}
