% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/olink_normalization_utils.R
\name{olink_norm_input_check}
\alias{olink_norm_input_check}
\title{Check inputs of \code{\link{olink_normalization}} function.}
\usage{
olink_norm_input_check(
  df1,
  df2,
  overlapping_samples_df1,
  overlapping_samples_df2,
  df1_project_nr,
  df2_project_nr,
  reference_project,
  reference_medians
)
}
\arguments{
\item{df1}{First dataset to be used in normalization (required).}

\item{df2}{Second dataset to be used in normalization.}

\item{overlapping_samples_df1}{Samples to be used for adjustment factor
calculation in df1 (required).}

\item{overlapping_samples_df2}{Samples to be used for adjustment factor
calculation in df2.}

\item{df1_project_nr}{Project name of first dataset (df1).}

\item{df2_project_nr}{Project name of first dataset (df2).}

\item{reference_project}{Project name of reference_project. Should be one of
\var{df1_project_nr} or \var{df2_project_nr}. Indicates the project to which
the other project is adjusted to.}

\item{reference_medians}{Dataset with columns "OlinkID" and "Reference_NPX".
Used for reference median normalization.}
}
\value{
Named list of updated inputs to use for normalization:
\itemize{
\item \code{df1}: dataset df1.
\item \code{df2}: \code{NULL} if reference median normalization, or dataset df2.
\item \code{overlapping_samples_df1}: character vector of reference samples from df1.
\item \code{overlapping_samples_df2}: \code{NULL} if reference median normalization, or
character vector of reference samples from df1.
\item \code{df1_project_nr}: name of df1 project.
\item \code{df2_project_nr}: \code{NULL} if reference median normalization, or name of df2
project.
\item \code{reference_project}: \code{NULL} if reference median normalization, or name of
reference project.
\item \code{reference_medians}: \code{NULL} if bridge or subset normalization, or dataset
with reference_medians.
\item \code{df1_cols}: column names of df1 to use downstream.
\item \code{df2_cols}: \code{NULL} if reference median normalization, or column names of
df2 to use downstream.
\item \code{norm_mode}: one of bridge, subset, ref_median, and norm_ht_3k
indicating the normalization to be performed.
}
}
\description{
This function is a wrapper of multiple help functions which check the inputs
of the \code{\link{olink_normalization}} function.
}
\details{
The following checks are performed:
\itemize{
\item \code{\link{olink_norm_input_validate}}:
\itemize{
\item Determines the normalization to be performed by intersecting inputs with
internal global variable \code{olink_norm_mode_combos}.
\item Returns the type of normalization to be performed from
\code{olink_norm_modes}.
\item Message with the normalization type.
\item Error message if input is invalid.
}
\item \code{\link{olink_norm_input_class}}:
\itemize{
\item Checks if all inputs are of the expected class:
\itemize{
\item \code{df1}, \code{df2} and \code{reference_medians}: tibble or R6 ArrowObject
\item \code{overlapping_samples_df1}, \code{overlapping_samples_df2},
\code{df1_project_nr}, \code{df2_project_nr} and \code{reference_project}: Character
vector
}
\item Also checks the validity of names of project and reference project.
\item Error if invalid input classes are detected.
}
\item \code{\link{olink_norm_input_check_df_cols}}:
\itemize{
\item Detects the column names of input datasets \code{df1} and \code{df2} to allow for
alternative names.
\item Returns named list of column names to use downstream.
\item Warning if \code{Normalization} column missing from all datasets.
\item Warning if \code{LOD} is missing or if there are multiple \code{LOD} columns.
\item Error if required columns are missing.
\item Error if not all input datasets have or lack \code{Normalization} column.
\item Error if input datasets have been quantified with different methods.
}
\item \code{\link{olink_norm_input_ref_medians}}:
\itemize{
\item Checks validity of dataset containing \code{reference_medians}.
\item Error if required columns are missing based on
\code{olink_norm_ref_median_cols}.
\item Error if columns are not of the correct class bases on
\code{olink_norm_ref_median_cols}.
\item Error if there duplicate assay identifiers.
}
\item \code{\link{olink_norm_input_check_samples}}:
\itemize{
\item Check character vectors of reference sample identifiers for:
\itemize{
\item Being present in \code{df1} and/or \code{df2}.
\item Duplicate identifiers.
}
}
\item \code{\link{olink_norm_input_clean_assays}}:
\itemize{
\item Returns a named list with the updated \code{df1}, \code{df2} and/or
\code{reference_medians}.
\item Removes assays that are not of the format OID followed by 5 digits.
\item Removes assays that are marked with \code{Normalization = EXCLUDED}.
}
\item \code{\link{olink_norm_input_assay_overlap}}:
\itemize{
\item Returns a named list with the updated \code{df1}, \code{df2} and/or
\code{reference_medians}.
\item Remove assays not shared between \code{df1} and \code{df2}, or between \code{df1} and
\code{reference_medians}.
}
\item \code{\link{olink_norm_input_norm_method}}:
\itemize{
\item Check if all assays in \code{df1} and \code{df2} have been originally normalized
with the same method "Intensity" or "Plate control".
\item Warning is thrown if not.
}
}
}
\author{
Klev Diamanti
}
