% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blrm_trial.R
\name{blrm_trial}
\alias{blrm_trial}
\alias{print.blrm_trial}
\title{Dose-Escalation Trials guided by Bayesian Logistic Regression Model}
\usage{
blrm_trial(data, dose_info, drug_info, simplified_prior = FALSE,
  EXNEX_comp = TRUE, EX_prob_comp_hist = 1, EX_prob_comp_new = 0.8,
  EXNEX_inter = FALSE, EX_prob_inter = 0.8,
  formula_generator = blrm_formula_linear, interval_prob = c(0, 0.16,
  0.33, 1), interval_max_mass = c(prob_underdose = 1, prob_target = 1,
  prob_overdose = 0.25), ...)

\method{print}{blrm_trial}(x, ...)
}
\arguments{
\item{data}{dose-toxicity data available at design stage of trial}

\item{dose_info}{specificaion of the dose levels as
planned for the ongoing trial arms.}

\item{drug_info}{specification of drugs used in trial arms.}

\item{simplified_prior}{logical (defaults to \code{FALSE})
indicating whether a simplified prior should be employed based
on the \code{reference_p_dlt} values provided in
\code{drug_info}. \strong{Warning:} The simplified prior will
change between releases. Please read instructions below in the
respective section for the simplified prior.}

\item{EXNEX_comp}{logical (default to \code{TRUE}) indicating
whether EXchangeable-NonEXchangeable priors should be employed
for all component parameters}

\item{EX_prob_comp_hist}{prior weight (\eqn{[0,1]}, default to 1)
on exchangeability for the component parameters in groups
representing historical data}

\item{EX_prob_comp_new}{prior weight (\eqn{[0,1]}, default to 0.8)
on exchangeability for the component parameters in groups
representing new or concurrent data}

\item{EXNEX_inter}{logical (default to \code{FALSE}) indicating
whether EXchangeable-NonEXchangeable priors should be employed
for all interaction parameters}

\item{EX_prob_inter}{prior weight (\eqn{[0,1]}, defaults to 0.8) on
exchangeability for the interaction parameters}

\item{formula_generator}{formula generation function (see for
example \code{blrm_formula_linear}). The formula generator
defines the employed interaction model.}

\item{interval_prob}{defines the interval probabilities reported in
the standard outputs. Defaults to \code{c(0, 0.16, 0.33, 1)}.}

\item{interval_max_mass}{named vector defining for each interval of
the \code{interval_prob} vector a maxmimal admissable
probability mass for a given dose level. Whenever the posterior
probability mass in a given interval exceeds the threshold,
then the Escalation With Overdose Control (EWOC) criterion is
considered to be not fullfilled. Dose levels not fullfilling
EWOC are ineligible for the next cohort of patients. The
default restricts the overdose probability to less than 0.25.}

\item{...}{Additional arguments are forwarded to \code{blrm_exnex},
i.e. for the purpose of prior specification.}

\item{x}{\code{blrm_trial} object to print}
}
\value{
The function returns an object of class \code{blrm_trial}.
}
\description{
\code{blrm_trial} facilitates the conduct of dose
    escalation studies guided by Bayesian Logistic Regression
    Models (BLRM). While the \code{blrm_exnex} only fits the BLRM
    model to data, the \code{blrm_trial} function standardizes the
    specification of the entire trial design and provides various
    standardized functions for trial data accrual and derivation of
    model summaries needed for dose-escalation decisions.
}
\details{
\code{blrm_trial} constructs an object of class
    \code{blrm_trial} which stores the compelte information about
    the study design of a dose-escalation trial. The study design
    is defined through the data sets (see sections below for a
    definition of the columns):

\describe{

\item{data (historical data)}{The \code{data} argument defines
available dose-toxicity data at the design stage of the
trial. Together with the prior of model (without any data) this
defines the prior used for the trial conduct.}

\item{dose_info}{Definition of the pre-specified dose levels
explored in the ongoing trial arms. Thus, all dose-toxcitiy trial
data added to the object is expected correspond to one of the dose
levels in the pre-defined set of dose_info.}

\item{drug_info}{Determines the drugs used in the trial, their
units, reference dose level and optionally defines the expected
probability for a toxicity at the reference dose.}

}

Once the \code{blrm_trial} object is setup the complete trial
design is specified and the model is fitted to the given
\code{data}. This allows evaluation of the pre-specified dose
levels of the trial design wrt. to safety, i.e. whether the
starting dose of the trial fullfills the escalate with overdose
criterion (EWOC) condition.

The \code{blrm_trial} trial can also be constructed in a 2-step
process which allows for a more convenient specification of the
prior since meta data like number of drugs and the like can be
used. See the example section for details.

After setup of the initial \code{blrm_trial} object additional data
is added through the use of the \code{update} method which has a
\code{add_data} argument intended to add data from the ongoing
trial. The \code{summary} function finally allows to extract
various model summaries. In particular, the EWOC criterion can be
calculated for the pre-defined dose levels of the trial.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print}: print function.
}}

\section{Simplified prior}{


As a convenience for the user, a simplified prior can be specifed
whenever the \code{reference_p_dlt} column is present in the
\code{drug_info} data set. However, the user is \strong{warned}
that the simplified prior will change in future releases of the
package and thus \strong{we strongly discourage the use of the
simplified prior for setting up trial designs}. The functionality
is intended to provide the user a quick start and as a starting
point. The actually instantiated prior can be seen as demonstrated
below in the examples.
}

\section{Input data}{


The data given to the \code{data} argument of \code{blrm_trial} is
considered as the available at design stage of the trial. The
collected input data thus does not necessarily need to have the
same dose levels as the pre-specified dose_info for the
ongoing trial(s). It's data columns must include, but are not
limited to:

\describe{
  \item{group_id}{study}

  \item{stratum_id}{optional, only required for differential discounting of groups}

  \item{num_patients}{number of patients}

  \item{num_toxicities}{number of toxicities}

  \item{drug_A}{Columns for the dose of each treatment component,
  with column names matching the \code{drug_name} values specified
  in the \code{drug_info} argument of \code{blrm_trial}}

}
}

\section{Drug info data}{


The drug information data-set defines drug properties. The fields
included are:

\describe{
  \item{drug_name}{name of drug which is also used as column name for the dose}
  \item{dose_ref}{reference dose}
  \item{dose_unit}{units used for drug amounts}
  \item{reference_p_dlt}{optional; if provided, allows setup of a simplified prior}
}
}

\section{Dose info data}{


The \code{drug_info} data-set pre-specifies the dose levels of the
ongoing trial. Thus, all data added to the \code{blrm_trial}
through the \code{update} command must be consistent with the
pre-defined dose levels as no other than those pre-specified ones
can be explored in an ongoing trial.

\describe{

\item{dose_id}{optional column which assigns a unique id to each
group_id/dose combination. If not specified the column is
internally generated.}

\item{group_id}{study}

\item{drug_A}{Columns for the dose of each treatment component,
  with column names matching the \code{drug_name} values specified
  in the \code{drug_info} argument of \code{blrm_trial}}

}
}

\examples{
## Setting up dummy sampling for fast execution of example
## Please use 4 chains and 100x more warmup & iter in practice
.user_mc_options <- options(OncoBayes2.MC.warmup=10, OncoBayes2.MC.iter=20, OncoBayes2.MC.chains=1)


# construct initial blrm_trial object from built-in example datasets
combo2_trial_setup <- blrm_trial(
  data = hist_combo2,
  dose_info = dose_info_combo2,
  drug_info = drug_info_combo2,
  simplified_prior = TRUE
)

# extract blrm_call to see setup of the prior as passed to blrm_exnex
summary(combo2_trial_setup, "blrm_exnex_call")

# Warning: The simplified prior will change between releases!
# please refer to the combo2_trial example for a complete
# example. You can obtain this example with
# ?example-combo2_trial
# or by running
# example_model("combo2_trial")

## Recover user set sampling defaults
options(.user_mc_options)

}
\references{
Babb, J., Rogatko, A., & Zacks, S. (1998). Cancer 
 phase I clinical trials: efficient dose escalation with overdose 
 control. \emph{Statistics in medicine}, 17(10), 1103-1120.

Neuenschwander, B., Roychoudhury, S., & Schmidli, H. 
 (2016). On the use of co-data in clinical trials. \emph{Statistics in 
 Biopharmaceutical Research}, 8(3), 345-354.
}
\seealso{
Other blrm_trial combo2 example: \code{\link{dose_info_combo2}},
  \code{\link{drug_info_combo2}},
  \code{\link{example-combo2_trial}}
}
\concept{blrm_trial combo2 example}
