% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.blrm_trial}
\alias{summary.blrm_trial}
\title{Summarise trial}
\usage{
\method{summary}{blrm_trial}(object, summarize = c("blrmfit",
  "blrm_exnex_call", "dose_info", "dose_prediction", "data",
  "data_prediction", "dimensionality"), ...)
}
\arguments{
\item{object}{\code{\link{blrm_trial}} object}

\item{summarize}{one of the following options:
\itemize{
  \item{}{\code{blrmfit}: summary of the underlying blrmfit object with further arguments ...}
  \item{}{\code{blrm_exnex_call}: blrm_exnex call used to create the \code{blrmfit} object}
  \item{}{\code{dose_info}: dose_info that were defined}
  \item{}{\code{dose_prediction} prediction for the defined dose_info}
  \item{}{\code{data}: data that were observed}
  \item{}{\code{data_prediction}: prediction for the observed data}
  \item{}{\code{dimensionality}: numeric vector with entries "num_components", "num_interaction_terms", "num_groups", "num_strata" }
}}

\item{...}{further arguments for summary.blrmfit}
}
\description{
Provides model summaries for \code{\link{blrm_trial}} analyses.
}
\examples{
## Setting up dummy sampling for fast execution of example
## Please use 4 chains and 100x more warmup & iter in practice
.user_mc_options <- options(OncoBayes2.MC.warmup=10, OncoBayes2.MC.iter=20, OncoBayes2.MC.chains=1)

# construct initial blrm_trial object from built-in example datasets
combo2_trial_setup <- blrm_trial(
  data = hist_combo2,
  dose_info = dose_info_combo2,
  drug_info = drug_info_combo2,
  simplified_prior = TRUE
)

# extract blrm_call to see setup of the prior as passed to blrm_exnex
summary(combo2_trial_setup, "blrm_exnex_call")

## Recover user set sampling defaults
options(.user_mc_options)

}
