% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global.R
\name{rows_for_rules}
\alias{rows_for_rules}
\title{Rows for rules}
\usage{
rows_for_rules(data_formatted, report, broken_rules, rows)
}
\arguments{
\item{data_formatted}{A formatted data frame.}

\item{report}{A validation report generated by the 'validate' function.}

\item{broken_rules}{A data frame with broken rules information.}

\item{rows}{A vector of row indices specifying which rules from the suite of rules with errors to check for violations.}
}
\value{
A data frame with rows in the data that violate the specified rules.
}
\description{
Get the rows in the data that violate the specified rules.
}
\examples{
data("invalid_example")
data("test_rules")
# Generate a validation report
result_invalid <- validate_data(files_data = invalid_example,
                        data_names = c("methodology", "particles", "samples"),
                        file_rules = test_rules)

# Find the broken rules
broken_rules <- rules_broken(results = result_invalid$results[[1]], show_decision = TRUE)

# Get rows for the specified rules
violating_rows <- rows_for_rules(data_formatted = result_invalid$data_formatted[[1]], 
                                 report = result_invalid$report[[1]],
                                 broken_rules = broken_rules,
                                 rows = 1)
}
