% Generated by roxygen2 (4.0.2): do not edit by hand
\name{getCP}
\alias{getCP}
\title{Calculates the conditional power.}
\usage{
getCP(n2, p1, design, k, mode = 0, alpha = 0.05)
}
\arguments{
\item{n2}{number of patients to be enrolled in the second stage of the study.}

\item{p1}{response probability under the alternative hypothesis}

\item{design}{a dataframe containing all critical values for a Simon's two-stage design defined by the colums "r1", "n1", "r", "n" and "p0".
\itemize{
   \item r1 = critical value for the first stage (more than r1 responses needed to proceed to the second stage).
   \item n1 = number of patients enrolled in the first stage.
   \item r = critical value for the whole trial (more than r responses needed at the end of the study to reject the null hypothesis).
   \item n = number of patients enrolled in the whole trial.
   \item p0 = response probability under the null hypothesis.
}}

\item{k}{number of responses observed at the interim analysis.}

\item{mode}{a value out of \{0,1,2,3\} dedicating the methode spending the "rest alpha" (difference between nominal alpha level and actual alpha level for the given design).
\itemize{
   \item 0 = "rest alpha" is not used.
   \item 1 = "rest alpha" is spent proportionally.
   \item 2 = "rest alpha" is spent equally.
   \item 3 = "rest alpha" is spent only to the worst case scenario (minimal number of responses at the interim analysis so that the study can proceed to the second stage).
}}

\item{alpha}{overall significance level the trial was planned for.}
}
\description{
Calculates the conditional power for a given Simon's two-stage design in the interim analysis if the number of patients which should be enrolled in the second stage is altert to "n2".
}
\examples{
\dontrun{
#Calculate a Simon's two-stage design
design <- getSolutions()$Solutions[3,] #minimax-design for the default values.

#Assume 3 responses were observed in the interim analysis.
#Therefore the conditional power is only about 0.55.
#In order to raise the conditional power to 0.8 "n2" has to be increased.

#get the current "n2"
n2 <- design$n - design$n1

#set k to 3 (only 3 responses observed so far)
k = 3

#get the current conditional power
cp <- getCP(n2, design$p1, design, k, mode = 1, alpha = 0.05)
cp

#increase n2 until the conditional power is larger than 0.8
while(cp < 0.8){
n2 <- n2 + 1
# Assume we spent the "rest alpha" proportionally (in the planning phase)
# therefore we set "mode = 1".
cp <- getCP(n2, design$p1, design, k, mode = 1, alpha = 0.05)
}

n2
}
}
\references{
Englert S., Kieser M. (2012): Adaptive designs for single-arm phase II trials in oncology. Pharmaceutical Statistics 11,241-249.
}
\seealso{
\code{\link{getN2}}
}

