% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{getCE}
\alias{getCE}
\title{Calculates the conditional error.}
\usage{
getCE(design, k)
}
\arguments{
\item{design}{a dataframe containing all critical values for a Simon's two-stage design defined by the colums "r1", "n1", "r", "n" and "p0".
\itemize{
   \item r1 = critical value for the first stage (more than "r1" responses needed to proceed to the second stage).
   \item n1 = number of patients enrolled in the first stage.
   \item r = critical value for the whole trial (more than "r" responses needed at the end of the study to reject the null hypothesis).
   \item n = number of patients enrolled in the whole trial.
   \item p0 = response probability under the null hypothesis
}}

\item{k}{number of responses observed at the interim analysis.}
}
\description{
Calculates the conditional error at the interim analysis for a given Simon's design with "k" responses.
}
\examples{
\dontrun{
design <- getSolutions()$Solutions[1,]
conditional_error <- getCE(design, 4)
}
}

