% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{setupSub1Design}
\alias{setupSub1Design}
\title{Creates a "sub1"-object.}
\usage{
setupSub1Design(alpha = 0.1, beta = 0.1, pc0 = 0.6, pt0 = 0.7,
  pc1 = 0.8, pt1 = 0.9)
}
\arguments{
\item{alpha}{the maximal type I error rate.}

\item{beta}{the maximal type II error rate.}

\item{pc0}{the response probability for the subset endpoint under the null hypothesis.}

\item{pt0}{the response probability for the superset endpoint under the null hypothesis.}

\item{pc1}{the response probability for the subset endpoint under the alternative hypothesis.}

\item{pt1}{the response probability for the superset endpoint under the alternative hypothesis.}
}
\description{
Creates a "sub1"-object which can be used in the function \code{getSolutionsSub1} to identify possible designs.
}
\examples{
#Create "sub1"-object.
sub1 <- setupSub1Design()
#Calculate designs for the given "sub1"-object.
designs <- getSolutionsSub1(sub1)$Solutions
designs
}
