% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_image.R
\name{verify_image_extension}
\alias{verify_image_extension}
\title{Verify that the input image extension is valid}
\usage{
verify_image_extension(image_path, regex_img = "jpe?g|png|tif$|tiff$")
}
\arguments{
\item{image_path}{a character string specifying the path to the saved image}

\item{regex_img}{a character string specifying the regex used to verify if the image extension is valid}
}
\value{
either the image path extension or an error
}
\description{
Verify that the input image extension is valid
}
\details{
The OpenImageR package uses the 'readPNG', 'readJPEG' and 'readTIFF' R packages in the background. Thus, only image file path
extensions that can be processed from these R packages should be used as input to the 'readImage' function
}
\examples{

vec_img_ext = c('png', 'PNG', 'jpg', 'JPG', 'jpeg', 'JPEG', 'tif', 'TIF', 'tiff', 'TIFF')

vec_valid = sapply(vec_img_ext, function(x) {
  ext_iter = paste(c('example_image', x), collapse = '.')
  verify_image_extension(image_path = ext_iter)
})

all(vec_img_ext == vec_valid)
}
\references{
https://github.com/mlampros/OpenImageR/issues/25
}
