% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOMLFlow.R
\name{getOMLFlow}
\alias{getOMLFlow}
\title{Download an OpenML flow.}
\usage{
getOMLFlow(flow.id, cache.only = FALSE, verbosity = NULL)
}
\arguments{
\item{flow.id}{[\code{integer(1)}]\cr
ID of the implementation of an OpenML flow.}

\item{cache.only}{[\code{logical(1)}]\cr
Only try to retrieve the object from cache.
Will result in error if the object is not found.
Default is \code{FALSE}.}

\item{verbosity}{[\code{integer(1)}]\cr
Print verbose output on console? Possible values are:\cr
\code{0}: normal output,\cr
\code{1}: info output,\cr
\code{2}: debug output.\cr
Default is set via \code{\link{setOMLConfig}}.}
}
\value{
[\code{\link{OMLFlow}}].
}
\description{
Given an flow id, the corresponding \code{\link{OMLFlow}} is
downloaded if not already available in cache.
}
\examples{
\dontrun{
	r_ctree = getOMLFlow(flow.id = 2569)
	weka_bagging = getOMLFlow(flow.id = 2286)
}
}
\seealso{
Other downloading functions: \code{\link{getOMLDataSetQualities}},
  \code{\link{getOMLDataSet}}, \code{\link{getOMLRun}},
  \code{\link{getOMLStudy}}, \code{\link{getOMLTask}}

Other flow-related functions: \code{\link{convertOMLFlowToMlr}},
  \code{\link{deleteOMLObject}},
  \code{\link{listOMLFlows}},
  \code{\link{makeOMLFlowParameter}},
  \code{\link{makeOMLFlow}}, \code{\link{tagOMLObject}}
}
