% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openrepgrid.r
\docType{package}
\name{OpenRepGrid}
\alias{OpenRepGrid}
\alias{OpenRepGrid-package}
\title{\pkg{OpenRepGrid}: an R package for the analysis of repertory grids.}
\description{
\if{html}{\figure{logo.png}{options: style='float: right; padding-left: 10px;' alt='logo' width='120'}}
The \pkg{OpenRepGrid} package provides tools for the analysis of repertory grid data.
The repertory grid is a method devised by George Alexander Kelly
in his seminal work "The Psychology of Personal Constructs" published in 1955.
The repertory grid has been used in and outside the context of Personal Construct 
Psychology (PCP) in a broad range of fields. For an introduction into the 
technique see e.g. Fransella, Bell and Bannister (2003).
}
\note{
To get started with \pkg{OpenRepGrid} visit the project's home under
           \href{https://openrepgrid.org}{openrepgrid.org}. On this site you will find tutorials, 
           explanation about the theory, the analysis methods and the corresponding R code.

           To see the preferable citation of the \pkg{OpenRepGrid} package, type 
           \code{citation("OpenRepGrid")} into the R console.

           Disclaimer: Note that the package is distributed under the 
           \href{http://www.gnu.org/licenses/gpl-2.0.html}{GPL 2 license}.
           It is work in progress and is continuously being improved by hopefully 
           numerous contributors. It may contain bugs and errors.
           There is no warranty whatsoever for the program.
}
\references{
Fransella, F., Bell, R. C., & Bannister, D. (2003). \emph{A Manual for Repertory 
                 Grid Technique (2. Ed.)}. Chichester: John Wiley & Sons.

             Kelly, G. A. (1955). \emph{The psychology of personal constructs. Vol. I, II.} 
                 New York: Norton, (2nd printing: 1991, Routledge, London, New York).
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/markheckmann/OpenRepGrid}
}

}
\author{
\pkg{OpenRepGrid} is maintained by Mark Heckmann. 
           Other contributors: Alejandro García, Diego Vitali.
           Researchers interested in \href{http://docu.openrepgrid.org/contribute.html}{contributing}
           to the package are welcome.

           The \pkg{OpenRepGrid} code is hosted on \href{https://github.com/markheckmann/OpenRepGrid}{GitHub}.
           The GitHub site provides additional information and allows to file bug reports or feature requests.
           Bug reports can also be emailed to the package maintainer or issued on 
           \href{https://openrepgrid.org}{openrepgrid.org} under section \emph{Suggestions/Issues}.
           The package maintainer is Mark Heckmann <heckmann(dot)mark(at)gmail(dot)com>.
}
\keyword{package}
\keyword{repgrid}
