% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manage_na.R
\name{manage_na}
\alias{manage_na}
\alias{manage_na.default}
\alias{manage_na.OpenSpecy}
\title{Ignore or Remove NA intensities}
\usage{
manage_na(x, ...)

\method{manage_na}{default}(x, lead_tail_only = TRUE, ig_zero = FALSE, ...)

\method{manage_na}{OpenSpecy}(x, lead_tail_only = TRUE, ig_zero = FALSE, fun, type = "ignore", ...)
}
\arguments{
\item{x}{a numeric vector or an \R OpenSpecy object}

\item{lead_tail_only}{logical whether to only look at leading adn tailing values.}

\item{ig_zero}{logical, whether to ignore both zeros and NAs}

\item{fun}{the name of the function you want run.}

\item{type}{character of either "ignore" or "remove".}

\item{\ldots}{further arguments passed to \code{fun}.}
}
\value{
\code{manage_na()} return logical vectors of NA locations (if vector provided) or an
\code{OpenSpecy} object with ignored or removed NA values.
}
\description{
Sometimes you want to keep or remove NA values in intensities to allow for spectra with
varying shapes to be analyzed together or maintained in a single Open Specy object.
}
\examples{
manage_na(c(NA, -1, NA, 1, 10))
manage_na(c(NA, -1, NA, 1, 10), lead_tail_only = FALSE)
manage_na(c(NA, 0, NA, 1, 10), lead_tail_only = FALSE, ig_zero = TRUE)
data(raman_hdpe)
raman_hdpe$spectra[[1]][1:10] <- NA
manage_na(raman_hdpe, fun = make_rel) 
#would normally return all NA without na.rm = TRUE but doesn't here. 
manage_na(raman_hdpe, type = "remove") 
#will remove the first 10 values we set to NA

}
\seealso{
\code{OpenSpecy} object to be matched with a reference library
\code{fill_spec()} can be used to fill NA values in Open Specy objects.
\code{restrict_range()} can be used to restrict spectral ranges in other ways than removing NAs.
}
\author{
Win Cowger, Zacharias Steinmetz
}
