% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_multi.R
\name{read_any}
\alias{read_any}
\alias{read_zip}
\title{Read spectral data from multiple files}
\usage{
read_any(file, ...)

read_zip(file, range = NULL, res = 5, ...)
}
\arguments{
\item{file}{file to be read from or written to.}

\item{range}{argument passed to \code{c_spec()} when reading multiple files from zip folder.}

\item{res}{spectral resolution for merge, argument passed to \code{c_spec()}.}

\item{\ldots}{further arguments passed to the submethods.}
}
\value{
All \code{read_*()} functions return \code{OpenSpecy} objects
}
\description{
Wrapper functions for reading files in batch.
}
\details{
\code{read_any()} provides a single function to quickly read in any of the
supported formats, it assumes that the file extension will tell it how to
process the spectra.
\code{read_zip()} provides functionality for reading in spectral map files
with ENVI file format or as individual files in a zip folder. If individual
files, spectra are concatenated.
}
\examples{
\dontshow{data.table::setDTthreads(2)}
read_extdata("raman_hdpe.csv") |> read_any()
read_extdata("ftir_ldpe_soil.asp") |> read_any()
read_extdata("testdata_zipped.zip") |> read_zip()
read_extdata("CA_tiny_map.zip") |> read_zip()

}
\seealso{
\code{\link{read_spec}()}
}
\author{
Zacharias Steinmetz, Win Cowger
}
