% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptHoldoutSize_estimation.R
\name{powerlaw}
\alias{powerlaw}
\title{Power law function}
\usage{
powerlaw(n, theta)
}
\arguments{
\item{n}{Set of training set sizes to evaluate}

\item{theta}{Parameter of values}
}
\value{
Vector of values of same length as \code{n}
}
\description{
Power law function for modelling learning curve (taken to mean change in expected loss per sample with training set size)

Recommended in \href{https://arxiv.org/abs/2103.10948}{review of learning curve forms}

If \code{theta=c(a,b,c)} then models as \verb{a n^(-b) + c}. Note \code{b} is negated.

Note that \code{powerlaw(n,c(a,b,c))} has limit \code{c} as \code{n} tends to infinity, if \verb{a,b > 0}
}
\examples{

ncheck=seq(1000,10000)
plot(ncheck, powerlaw(ncheck, c(5e3,1.2,0.3)),type="l",xlab="n",ylab="powerlaw(n)")

}
