\name{Opt.SigBootWeight}
\alias{Opt.SigBootWeight}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Weighted Optimal Significance Level for the F-test based on the bootstrap
}
\description{
The function calculates the weighted optimal level of significance for the F-test 

The weights are obtained from the bootstrap distribution of the non-centrality parameter estimates

}
\usage{
Opt.SigBootWeight(y,x,Rmat,rvec,p=0.5,k=1,nboot=3000,wild=FALSE,Figure=TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
 \item{y}{ a matrix of dependent variable, T by 1}
  \item{x}{ a matrix of K independent variable, T by K}
  \item{Rmat}{ a matrix for J restrictions, J by (K+1) }
  \item{rvec}{ a vector for restrictions, J by 1}
  \item{p}{ prior probability for H0, default is p = 0.5}
  \item{k}{ relative loss from Type I and II errors, k = L2/L1, default is k = 1}
  \item{nboot}{ the number of bootstrap iterations, the default is 3000}
  \item{wild}{ if TRUE, wild bootsrap is conducted (default); if FALSE, bootstrap is based on iid resampling}
  \item{Figure}{ show graph if TRUE . No graph if FALSE (default) }
}
\details{
The bootstrap can be conducted using either iid resampling or wild bootstrap.
}
\value{
\item{alpha.opt }{Optimal level of significance}
\item{crit.opt }{Critical value at the optimal level}
}
\references{
Kim and Choi, 2017, Choosing the Level of Significance: A Decision-theoretic Approach: https://papers.ssrn.com/sol3/papers.cfm?abstract_id=2652773
}
\author{
Jae H. Kim
}
\note{
Applicable to a linear regression model
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
Leamer, E. 1978, Specification Searches: Ad Hoc Inference with Nonexperimental Data, Wiley, New York.

Kim, JH and Ji, P. 2015, Significance Testing in Empirical Finance: A Critical Review and Assessment, Journal of Empirical Finance 34, 1-14.
<DOI:http://dx.doi.org/10.1016/j.jempfin.2015.08.006>
}
\examples{
data(data1)
# Define Y and X
y=data1$lnoutput; x=cbind(data1$lncapital,data1$lnlabor)
# Restriction matrices to test for constant returns to scale
Rmat=matrix(c(0,1,1),nrow=1); rvec=matrix(0.94,nrow=1)

Opt.SigBoot(y,x,Rmat,rvec,p=0.5,k=1,nboot=2000,Figure=TRUE)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ htest }% use one of  RShowDoc("KEYWORDS")

