% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBinaryData.R
\name{getBinaryData}
\alias{getBinaryData}
\title{Get Raw Binary Data for Detections}
\usage{
getBinaryData(
  x,
  UID,
  type = c("click", "whistle", "cepstrum"),
  quiet = FALSE,
  ...
)
}
\arguments{
\item{x}{a \linkS4class{AcousticStudy} object, a list of \linkS4class{AcousticEvent}
objects, or a single \linkS4class{AcousticEvent} object}

\item{UID}{the UID(s) of the individual detections to fetch the binary
data for}

\item{type}{detection type}

\item{quiet}{logical flag to quiet some warnings, used internally and should generally
not be changed from default \code{FALSE}}

\item{\dots}{additional arguments to pass to
\code{\link[PamBinaries]{loadPamguardBinaryFile}}}
}
\value{
a list of \code{PamBinary} objects for each \code{UID}
}
\description{
Fetches matching binary data from a single or multiple
  detections in an \linkS4class{AcousticEvent} object
}
\examples{

data(exStudy)
binData <- getBinaryData(exStudy, UID = 8000003)
# works with multiple UIDs, if UIDs arent present they will be ignored
binData <- getBinaryData(exStudy, UID = c(8000003, 529000024, 1))

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
