# ***********************************************************
# calcGM:
#  Calculate the geometric mean of a numeric vector, possibly
#  excluding zeros and/or adding an offset to compensate for
#  zero values
# Arguments:
#  x      - vector of numbers
#  offset - value added to compensate for zeroes
#  exzero - if T, exclude zeroes from x
# -----------------------------------------------------------
calcGM <- function (x, offset = 0, exzero = TRUE) {
  x <- x[!is.na(x)]
  if (exzero) x <- x[x > 0 & !is.na(x)]
  n <- length(x)
  if (n == 0) return(0)
  x <- x + offset
  g <- exp(mean(log(x)))
  return(g) }
