% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCMParam.R
\name{PCMParamSetByName}
\alias{PCMParamSetByName}
\title{Set model parameters from a named list}
\usage{
PCMParamSetByName(model, params, inplace = TRUE,
  replaceWholeParameters = FALSE, deepCopySubPCMs = FALSE,
  failIfNamesInParamsDontExist = TRUE, ...)
}
\arguments{
\item{model}{a PCM model object}

\item{params}{a named list with elements among the names found in model}

\item{inplace}{logical indicating if the parameters should be set "inplace"
for the model object in the calling environment or a new model object with
the parameters set as specified should be returned. Defaults to TRUE.}

\item{replaceWholeParameters}{logical, by default set to FALSE. If TRUE, the
parameters will be completely replaced, meaning that their attributes (e.g.
S3 class) will be replaced as well (dangerous).}

\item{deepCopySubPCMs}{a logical indicating whether nested PCMs should be
'deep'-copied, meaning element by element, eventually preserving the
attributes as in \code{model}. By default this is set to FALSE, meaning
that sub-PCMs found in \code{params} will completely overwrite the
sub-PCMs with the same name in \code{model}.}

\item{failIfNamesInParamsDontExist}{logical indicating if an error should be
raised if \code{params} contains elements not existing in model. Default: TRUE.}

\item{...}{other arguments that can be used by implementing methods.}
}
\value{
If inplace is TRUE, the function only has a side effect of setting
the parameters of the model object in the calling environment; otherwise the
function returns a modified copy of the model object.
}
\description{
Set model parameters from a named list
}
